@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sag.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property activeAging The time interval at which log data of active connections is collected. Valid values: 60 to 6000. Default value: 300. Unit: second.
 * @property description The description of the flow log.
 * @property flowLogId The ID of the flow log.
 * @property flowLogName The name of the flow log.
 * @property id The ID of the Flow Log.
 * @property inactiveAging The time interval at which log data of inactive connections is connected. Valid values: 10 to 600. Default value: 15. Unit: second.
 * @property logstoreName The name of the Log Service Logstore.
 * @property netflowServerIp The IP address of the NetFlow collector where the flow log is stored.
 * @property netflowServerPort The port of the NetFlow collector. Default value: 9995.
 * @property netflowVersion The NetFlow version. Default value: V9.
 * @property outputType The location where the flow log is stored. Valid values:  sls: The flow log is stored in Log Service. netflow: The flow log is stored on a NetFlow collector. all: The flow log is stored both in Log Service and on a NetFlow collector.
 * @property projectName The name of the Log Service project.
 * @property resourceGroupId The ID of the resource group.
 * @property slsRegionId The ID of the region where Log Service is deployed.
 * @property status The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
 * @property totalSagNum The number of Smart Access gateway (SAG) instances with which the flow log is associated.
 */
public data class GetSmartagFlowLogsLog(
    public val activeAging: Int,
    public val description: String,
    public val flowLogId: String,
    public val flowLogName: String,
    public val id: String,
    public val inactiveAging: Int,
    public val logstoreName: String,
    public val netflowServerIp: String,
    public val netflowServerPort: Int,
    public val netflowVersion: String,
    public val outputType: String,
    public val projectName: String,
    public val resourceGroupId: String,
    public val slsRegionId: String,
    public val status: String,
    public val totalSagNum: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sag.outputs.GetSmartagFlowLogsLog): GetSmartagFlowLogsLog = GetSmartagFlowLogsLog(
            activeAging = javaType.activeAging(),
            description = javaType.description(),
            flowLogId = javaType.flowLogId(),
            flowLogName = javaType.flowLogName(),
            id = javaType.id(),
            inactiveAging = javaType.inactiveAging(),
            logstoreName = javaType.logstoreName(),
            netflowServerIp = javaType.netflowServerIp(),
            netflowServerPort = javaType.netflowServerPort(),
            netflowVersion = javaType.netflowVersion(),
            outputType = javaType.outputType(),
            projectName = javaType.projectName(),
            resourceGroupId = javaType.resourceGroupId(),
            slsRegionId = javaType.slsRegionId(),
            status = javaType.status(),
            totalSagNum = javaType.totalSagNum(),
        )
    }
}
