@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sag.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSmartagFlowLogs.
 * @property description
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property logs
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status
 */
public data class GetSmartagFlowLogsResult(
    public val description: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val logs: List<GetSmartagFlowLogsLog>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sag.outputs.GetSmartagFlowLogsResult): GetSmartagFlowLogsResult = GetSmartagFlowLogsResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            logs = javaType.logs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sag.kotlin.outputs.GetSmartagFlowLogsLog.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
