@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin

import com.pulumi.alicloud.scdn.kotlin.outputs.DomainCertInfo
import com.pulumi.alicloud.scdn.kotlin.outputs.DomainSource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.scdn.kotlin.outputs.DomainCertInfo.Companion.toKotlin as domainCertInfoToKotlin
import com.pulumi.alicloud.scdn.kotlin.outputs.DomainSource.Companion.toKotlin as domainSourceToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.alicloud.scdn.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides a SCDN Domain resource.
 * For information about SCDN Domain and how to use it, see [What is Domain](https://help.aliyun.com/document_detail/63672.html).
 * > **NOTE:** Available in v1.131.0+.
 * > **NOTE:** Alibaba Cloud SCDN has stopped new customer purchases from January 26, 2023, and you can choose to buy Alibaba Cloud DCDN products with more comprehensive acceleration and protection capabilities. If you are already a SCDN customer, you can submit a work order at any time to apply for a smooth migration to Alibaba Cloud DCDN products. In the future, we will provide better acceleration and security protection services in Alibaba Cloud DCDN, thank you for your understanding and cooperation.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.aliyun.com/product/scdn) from version `1.219.0`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.scdn.Domain("example", {
 *     domainName: "my-Domain",
 *     sources: [{
 *         content: "xxx.aliyuncs.com",
 *         enabled: "online",
 *         port: 80,
 *         priority: "20",
 *         type: "oss",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.scdn.Domain("example",
 *     domain_name="my-Domain",
 *     sources=[{
 *         "content": "xxx.aliyuncs.com",
 *         "enabled": "online",
 *         "port": 80,
 *         "priority": "20",
 *         "type": "oss",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Scdn.Domain("example", new()
 *     {
 *         DomainName = "my-Domain",
 *         Sources = new[]
 *         {
 *             new AliCloud.Scdn.Inputs.DomainSourceArgs
 *             {
 *                 Content = "xxx.aliyuncs.com",
 *                 Enabled = "online",
 *                 Port = 80,
 *                 Priority = "20",
 *                 Type = "oss",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/scdn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scdn.NewDomain(ctx, "example", &scdn.DomainArgs{
 * 			DomainName: pulumi.String("my-Domain"),
 * 			Sources: scdn.DomainSourceArray{
 * 				&scdn.DomainSourceArgs{
 * 					Content:  pulumi.String("xxx.aliyuncs.com"),
 * 					Enabled:  pulumi.String("online"),
 * 					Port:     pulumi.Int(80),
 * 					Priority: pulumi.String("20"),
 * 					Type:     pulumi.String("oss"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.scdn.Domain;
 * import com.pulumi.alicloud.scdn.DomainArgs;
 * import com.pulumi.alicloud.scdn.inputs.DomainSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName("my-Domain")
 *             .sources(DomainSourceArgs.builder()
 *                 .content("xxx.aliyuncs.com")
 *                 .enabled("online")
 *                 .port(80)
 *                 .priority("20")
 *                 .type("oss")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:scdn:Domain
 *     properties:
 *       domainName: my-Domain
 *       sources:
 *         - content: xxx.aliyuncs.com
 *           enabled: online
 *           port: 80
 *           priority: '20'
 *           type: oss
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SCDN Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:scdn/domain:Domain example <domain_name>
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.alicloud.scdn.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * Attribute perm has been deprecated and suggest removing it from your template.
     */
    @Deprecated(
        message = """
  Attribute biz_name has been deprecated and suggest removing it from your template.
  """,
    )
    public val bizName: Output<String>?
        get() = javaResource.bizName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Certificate Information. See the following `Block cert_infos`.
     */
    public val certInfos: Output<List<DomainCertInfo>>?
        get() = javaResource.certInfos().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> domainCertInfoToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The health check url.
     */
    public val checkUrl: Output<String>?
        get() = javaResource.checkUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of domain.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Whether to set certificate forcibly.
     */
    public val forceSet: Output<String>?
        get() = javaResource.forceSet().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource group id.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * the Origin Server Information. See the following `Block sources`.
     */
    public val sources: Output<List<DomainSource>>
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    domainSourceToKotlin(args0)
                })
            })
        })

    /**
     * The status of the resource. Valid values: `offline`, `online`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.scdn.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.alicloud.scdn.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
