@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin

import com.pulumi.alicloud.scdn.DomainArgs.builder
import com.pulumi.alicloud.scdn.kotlin.inputs.DomainCertInfoArgs
import com.pulumi.alicloud.scdn.kotlin.inputs.DomainCertInfoArgsBuilder
import com.pulumi.alicloud.scdn.kotlin.inputs.DomainSourceArgs
import com.pulumi.alicloud.scdn.kotlin.inputs.DomainSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a SCDN Domain resource.
 * For information about SCDN Domain and how to use it, see [What is Domain](https://help.aliyun.com/document_detail/63672.html).
 * > **NOTE:** Available in v1.131.0+.
 * > **NOTE:** Alibaba Cloud SCDN has stopped new customer purchases from January 26, 2023, and you can choose to buy Alibaba Cloud DCDN products with more comprehensive acceleration and protection capabilities. If you are already a SCDN customer, you can submit a work order at any time to apply for a smooth migration to Alibaba Cloud DCDN products. In the future, we will provide better acceleration and security protection services in Alibaba Cloud DCDN, thank you for your understanding and cooperation.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.aliyun.com/product/scdn) from version `1.219.0`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.scdn.Domain("example", {
 *     domainName: "my-Domain",
 *     sources: [{
 *         content: "xxx.aliyuncs.com",
 *         enabled: "online",
 *         port: 80,
 *         priority: "20",
 *         type: "oss",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.scdn.Domain("example",
 *     domain_name="my-Domain",
 *     sources=[{
 *         "content": "xxx.aliyuncs.com",
 *         "enabled": "online",
 *         "port": 80,
 *         "priority": "20",
 *         "type": "oss",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Scdn.Domain("example", new()
 *     {
 *         DomainName = "my-Domain",
 *         Sources = new[]
 *         {
 *             new AliCloud.Scdn.Inputs.DomainSourceArgs
 *             {
 *                 Content = "xxx.aliyuncs.com",
 *                 Enabled = "online",
 *                 Port = 80,
 *                 Priority = "20",
 *                 Type = "oss",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/scdn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scdn.NewDomain(ctx, "example", &scdn.DomainArgs{
 * 			DomainName: pulumi.String("my-Domain"),
 * 			Sources: scdn.DomainSourceArray{
 * 				&scdn.DomainSourceArgs{
 * 					Content:  pulumi.String("xxx.aliyuncs.com"),
 * 					Enabled:  pulumi.String("online"),
 * 					Port:     pulumi.Int(80),
 * 					Priority: pulumi.String("20"),
 * 					Type:     pulumi.String("oss"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.scdn.Domain;
 * import com.pulumi.alicloud.scdn.DomainArgs;
 * import com.pulumi.alicloud.scdn.inputs.DomainSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName("my-Domain")
 *             .sources(DomainSourceArgs.builder()
 *                 .content("xxx.aliyuncs.com")
 *                 .enabled("online")
 *                 .port(80)
 *                 .priority("20")
 *                 .type("oss")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:scdn:Domain
 *     properties:
 *       domainName: my-Domain
 *       sources:
 *         - content: xxx.aliyuncs.com
 *           enabled: online
 *           port: 80
 *           priority: '20'
 *           type: oss
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SCDN Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:scdn/domain:Domain example <domain_name>
 * ```
 * @property bizName Attribute perm has been deprecated and suggest removing it from your template.
 * @property certInfos Certificate Information. See the following `Block cert_infos`.
 * @property checkUrl The health check url.
 * @property domainName The name of domain.
 * @property forceSet Whether to set certificate forcibly.
 * @property resourceGroupId The resource group id.
 * @property sources the Origin Server Information. See the following `Block sources`.
 * @property status The status of the resource. Valid values: `offline`, `online`.
 */
public data class DomainArgs(
    @Deprecated(
        message = """
  Attribute biz_name has been deprecated and suggest removing it from your template.
  """,
    )
    public val bizName: Output<String>? = null,
    public val certInfos: Output<List<DomainCertInfoArgs>>? = null,
    public val checkUrl: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val forceSet: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val sources: Output<List<DomainSourceArgs>>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.scdn.DomainArgs> {
    override fun toJava(): com.pulumi.alicloud.scdn.DomainArgs =
        com.pulumi.alicloud.scdn.DomainArgs.builder()
            .bizName(bizName?.applyValue({ args0 -> args0 }))
            .certInfos(
                certInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .checkUrl(checkUrl?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .forceSet(forceSet?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var bizName: Output<String>? = null

    private var certInfos: Output<List<DomainCertInfoArgs>>? = null

    private var checkUrl: Output<String>? = null

    private var domainName: Output<String>? = null

    private var forceSet: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var sources: Output<List<DomainSourceArgs>>? = null

    private var status: Output<String>? = null

    /**
     * @param value Attribute perm has been deprecated and suggest removing it from your template.
     */
    @Deprecated(
        message = """
  Attribute biz_name has been deprecated and suggest removing it from your template.
  """,
    )
    @JvmName("tblsmcktpxcnagaf")
    public suspend fun bizName(`value`: Output<String>) {
        this.bizName = value
    }

    /**
     * @param value Certificate Information. See the following `Block cert_infos`.
     */
    @JvmName("gpbwiixkgjidgxsl")
    public suspend fun certInfos(`value`: Output<List<DomainCertInfoArgs>>) {
        this.certInfos = value
    }

    @JvmName("bnwdjpufiythbqun")
    public suspend fun certInfos(vararg values: Output<DomainCertInfoArgs>) {
        this.certInfos = Output.all(values.asList())
    }

    /**
     * @param values Certificate Information. See the following `Block cert_infos`.
     */
    @JvmName("luurbdprsghcdtww")
    public suspend fun certInfos(values: List<Output<DomainCertInfoArgs>>) {
        this.certInfos = Output.all(values)
    }

    /**
     * @param value The health check url.
     */
    @JvmName("hcjmxdfpmqnaswqo")
    public suspend fun checkUrl(`value`: Output<String>) {
        this.checkUrl = value
    }

    /**
     * @param value The name of domain.
     */
    @JvmName("qnytktvmatbfkrfa")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Whether to set certificate forcibly.
     */
    @JvmName("idghtobqtgcgbihc")
    public suspend fun forceSet(`value`: Output<String>) {
        this.forceSet = value
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("fsuyamcfobbnasof")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value the Origin Server Information. See the following `Block sources`.
     */
    @JvmName("kffthccmtdeawcrb")
    public suspend fun sources(`value`: Output<List<DomainSourceArgs>>) {
        this.sources = value
    }

    @JvmName("nmrthbhpdagwieod")
    public suspend fun sources(vararg values: Output<DomainSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values the Origin Server Information. See the following `Block sources`.
     */
    @JvmName("hhrrsolmhpmyuudb")
    public suspend fun sources(values: List<Output<DomainSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value The status of the resource. Valid values: `offline`, `online`.
     */
    @JvmName("jsncycuxolsqwgqq")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Attribute perm has been deprecated and suggest removing it from your template.
     */
    @Deprecated(
        message = """
  Attribute biz_name has been deprecated and suggest removing it from your template.
  """,
    )
    @JvmName("arftenunlrlryuxp")
    public suspend fun bizName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bizName = mapped
    }

    /**
     * @param value Certificate Information. See the following `Block cert_infos`.
     */
    @JvmName("uprnmyoqumjiygdy")
    public suspend fun certInfos(`value`: List<DomainCertInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certInfos = mapped
    }

    /**
     * @param argument Certificate Information. See the following `Block cert_infos`.
     */
    @JvmName("joqxaiqvpbemqqba")
    public suspend fun certInfos(argument: List<suspend DomainCertInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainCertInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certInfos = mapped
    }

    /**
     * @param argument Certificate Information. See the following `Block cert_infos`.
     */
    @JvmName("ahowwtgwbtjurqup")
    public suspend fun certInfos(vararg argument: suspend DomainCertInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainCertInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certInfos = mapped
    }

    /**
     * @param argument Certificate Information. See the following `Block cert_infos`.
     */
    @JvmName("yglqvdslinnrkqjf")
    public suspend fun certInfos(argument: suspend DomainCertInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DomainCertInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.certInfos = mapped
    }

    /**
     * @param values Certificate Information. See the following `Block cert_infos`.
     */
    @JvmName("ftlsupsxwkjkuupv")
    public suspend fun certInfos(vararg values: DomainCertInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certInfos = mapped
    }

    /**
     * @param value The health check url.
     */
    @JvmName("ohdhnpqyiypqciss")
    public suspend fun checkUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkUrl = mapped
    }

    /**
     * @param value The name of domain.
     */
    @JvmName("iliovffydsqhcxvw")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Whether to set certificate forcibly.
     */
    @JvmName("rrxiemylmdtybanc")
    public suspend fun forceSet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceSet = mapped
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("iwmmmuroonwvcqub")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value the Origin Server Information. See the following `Block sources`.
     */
    @JvmName("wukdtswbrrgjoeem")
    public suspend fun sources(`value`: List<DomainSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument the Origin Server Information. See the following `Block sources`.
     */
    @JvmName("dcldhqabpwsuoyyf")
    public suspend fun sources(argument: List<suspend DomainSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument the Origin Server Information. See the following `Block sources`.
     */
    @JvmName("hmwprjxswhjhcwgj")
    public suspend fun sources(vararg argument: suspend DomainSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument the Origin Server Information. See the following `Block sources`.
     */
    @JvmName("saekydcuymimlsva")
    public suspend fun sources(argument: suspend DomainSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DomainSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values the Origin Server Information. See the following `Block sources`.
     */
    @JvmName("touerhuexvqfpfbt")
    public suspend fun sources(vararg values: DomainSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `offline`, `online`.
     */
    @JvmName("eiukoquvimuatwkr")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        bizName = bizName,
        certInfos = certInfos,
        checkUrl = checkUrl,
        domainName = domainName,
        forceSet = forceSet,
        resourceGroupId = resourceGroupId,
        sources = sources,
        status = status,
    )
}
