@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin

import com.pulumi.alicloud.scdn.kotlin.outputs.DomainConfigFunctionArg
import com.pulumi.alicloud.scdn.kotlin.outputs.DomainConfigFunctionArg.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DomainConfig].
 */
@PulumiTagMarker
public class DomainConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainConfigArgs = DomainConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainConfigArgsBuilder.() -> Unit) {
        val builder = DomainConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainConfig {
        val builtJavaResource = com.pulumi.alicloud.scdn.DomainConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainConfig(builtJavaResource)
    }
}

/**
 * Provides a SCDN Accelerated Domain resource.
 * For information about domain config and how to use it, see [Batch set config](https://help.aliyun.com/document_detail/92912.html)
 * > **NOTE:** Available in v1.131.0+.
 * > **NOTE:** Alibaba Cloud SCDN has stopped new customer purchases from January 26, 2023, and you can choose to buy Alibaba Cloud DCDN products with more comprehensive acceleration and protection capabilities. If you are already a SCDN customer, you can submit a work order at any time to apply for a smooth migration to Alibaba Cloud DCDN products. In the future, we will provide better acceleration and security protection services in Alibaba Cloud DCDN, thank you for your understanding and cooperation.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.aliyun.com/product/scdn) from version `1.219.0`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   # Create a new Domain config.
 *   domain:
 *     type: alicloud:scdn:Domain
 *     properties:
 *       domainName: mydomain.alicloud-provider.cn
 *       cdnType: web
 *       scope: overseas
 *       sources:
 *         - content: 1.1.1.1
 *           type: ipaddr
 *           priority: '20'
 *           port: 80
 *   config:
 *     type: alicloud:scdn:DomainConfig
 *     properties:
 *       domainName: ${domain.domainName}
 *       functionName: ip_allow_list_set
 *       functionArgs:
 *         - argName: ip_list
 *           argValue: 110.110.110.110
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SCDN domain config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:scdn/domainConfig:DomainConfig example <domain_name>:<function_name>:<config_id>
 * ```
 */
public class DomainConfig internal constructor(
    override val javaResource: com.pulumi.alicloud.scdn.DomainConfig,
) : KotlinCustomResource(javaResource, DomainConfigMapper) {
    /**
     * The SCDN domain config id.
     */
    public val configId: Output<String>
        get() = javaResource.configId().applyValue({ args0 -> args0 })

    /**
     * Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The args of the domain config.
     */
    public val functionArgs: Output<List<DomainConfigFunctionArg>>
        get() = javaResource.functionArgs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The name of the domain config.
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * The status of this resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DomainConfigMapper : ResourceMapper<DomainConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.scdn.DomainConfig::class == javaResource::class

    override fun map(javaResource: Resource): DomainConfig = DomainConfig(
        javaResource as
            com.pulumi.alicloud.scdn.DomainConfig,
    )
}

/**
 * @see [DomainConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainConfig].
 */
public suspend fun domainConfig(
    name: String,
    block: suspend DomainConfigResourceBuilder.() -> Unit,
): DomainConfig {
    val builder = DomainConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainConfig(name: String): DomainConfig {
    val builder = DomainConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
