@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin

import com.pulumi.alicloud.scdn.DomainConfigArgs.builder
import com.pulumi.alicloud.scdn.kotlin.inputs.DomainConfigFunctionArgArgs
import com.pulumi.alicloud.scdn.kotlin.inputs.DomainConfigFunctionArgArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a SCDN Accelerated Domain resource.
 * For information about domain config and how to use it, see [Batch set config](https://help.aliyun.com/document_detail/92912.html)
 * > **NOTE:** Available in v1.131.0+.
 * > **NOTE:** Alibaba Cloud SCDN has stopped new customer purchases from January 26, 2023, and you can choose to buy Alibaba Cloud DCDN products with more comprehensive acceleration and protection capabilities. If you are already a SCDN customer, you can submit a work order at any time to apply for a smooth migration to Alibaba Cloud DCDN products. In the future, we will provide better acceleration and security protection services in Alibaba Cloud DCDN, thank you for your understanding and cooperation.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.aliyun.com/product/scdn) from version `1.219.0`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   # Create a new Domain config.
 *   domain:
 *     type: alicloud:scdn:Domain
 *     properties:
 *       domainName: mydomain.alicloud-provider.cn
 *       cdnType: web
 *       scope: overseas
 *       sources:
 *         - content: 1.1.1.1
 *           type: ipaddr
 *           priority: '20'
 *           port: 80
 *   config:
 *     type: alicloud:scdn:DomainConfig
 *     properties:
 *       domainName: ${domain.domainName}
 *       functionName: ip_allow_list_set
 *       functionArgs:
 *         - argName: ip_list
 *           argValue: 110.110.110.110
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SCDN domain config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:scdn/domainConfig:DomainConfig example <domain_name>:<function_name>:<config_id>
 * ```
 * @property domainName Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
 * @property functionArgs The args of the domain config.
 * @property functionName The name of the domain config.
 */
public data class DomainConfigArgs(
    public val domainName: Output<String>? = null,
    public val functionArgs: Output<List<DomainConfigFunctionArgArgs>>? = null,
    public val functionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.scdn.DomainConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.scdn.DomainConfigArgs =
        com.pulumi.alicloud.scdn.DomainConfigArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .functionArgs(
                functionArgs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .functionName(functionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainConfigArgs].
 */
@PulumiTagMarker
public class DomainConfigArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var functionArgs: Output<List<DomainConfigFunctionArgArgs>>? = null

    private var functionName: Output<String>? = null

    /**
     * @param value Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("lqekdsbuvqxjpxdv")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The args of the domain config.
     */
    @JvmName("ldrqjtjeorsowajc")
    public suspend fun functionArgs(`value`: Output<List<DomainConfigFunctionArgArgs>>) {
        this.functionArgs = value
    }

    @JvmName("haylvxshtedybolx")
    public suspend fun functionArgs(vararg values: Output<DomainConfigFunctionArgArgs>) {
        this.functionArgs = Output.all(values.asList())
    }

    /**
     * @param values The args of the domain config.
     */
    @JvmName("lowewjkyxvbtkeox")
    public suspend fun functionArgs(values: List<Output<DomainConfigFunctionArgArgs>>) {
        this.functionArgs = Output.all(values)
    }

    /**
     * @param value The name of the domain config.
     */
    @JvmName("bdaixrgcoerbfrwx")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("oxarqygcgfxxdmus")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The args of the domain config.
     */
    @JvmName("lsbrysdqlcpgikss")
    public suspend fun functionArgs(`value`: List<DomainConfigFunctionArgArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionArgs = mapped
    }

    /**
     * @param argument The args of the domain config.
     */
    @JvmName("grgfrskcvmpfhonl")
    public suspend fun functionArgs(argument: List<suspend DomainConfigFunctionArgArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainConfigFunctionArgArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.functionArgs = mapped
    }

    /**
     * @param argument The args of the domain config.
     */
    @JvmName("soqnecdowjserrlu")
    public suspend fun functionArgs(vararg argument: suspend DomainConfigFunctionArgArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainConfigFunctionArgArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.functionArgs = mapped
    }

    /**
     * @param argument The args of the domain config.
     */
    @JvmName("cnrrkkucfveerfyl")
    public suspend fun functionArgs(argument: suspend DomainConfigFunctionArgArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DomainConfigFunctionArgArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.functionArgs = mapped
    }

    /**
     * @param values The args of the domain config.
     */
    @JvmName("aoqqvepblpjxawxt")
    public suspend fun functionArgs(vararg values: DomainConfigFunctionArgArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionArgs = mapped
    }

    /**
     * @param value The name of the domain config.
     */
    @JvmName("aodiaoxakmryrtfe")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    internal fun build(): DomainConfigArgs = DomainConfigArgs(
        domainName = domainName,
        functionArgs = functionArgs,
        functionName = functionName,
    )
}
