@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin

import com.pulumi.alicloud.scdn.ScdnFunctions.getDomainsPlain
import com.pulumi.alicloud.scdn.kotlin.inputs.GetDomainsPlainArgs
import com.pulumi.alicloud.scdn.kotlin.inputs.GetDomainsPlainArgsBuilder
import com.pulumi.alicloud.scdn.kotlin.outputs.GetDomainsResult
import com.pulumi.alicloud.scdn.kotlin.outputs.GetDomainsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object ScdnFunctions {
    /**
     * This data source provides the Scdn Domains of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.131.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const nameRegex = alicloud.scdn.getDomains({
     *     nameRegex: "^my-Domain",
     * });
     * export const scdnDomainId = nameRegex.then(nameRegex => nameRegex.domains?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * name_regex = alicloud.scdn.get_domains(name_regex="^my-Domain")
     * pulumi.export("scdnDomainId", name_regex.domains[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var nameRegex = AliCloud.Scdn.GetDomains.Invoke(new()
     *     {
     *         NameRegex = "^my-Domain",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["scdnDomainId"] = nameRegex&#46;Apply(getDomainsResult => getDomainsResult&#46;Domains[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/scdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		nameRegex, err := scdn.GetDomains(ctx, &scdn.GetDomainsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Domain"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("scdnDomainId", nameRegex.Domains[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.scdn.ScdnFunctions;
     * import com.pulumi.alicloud.scdn.inputs.GetDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var nameRegex = ScdnFunctions.getDomains(GetDomainsArgs.builder()
     *             .nameRegex("^my-Domain")
     *             .build());
     *         ctx.export("scdnDomainId", nameRegex.applyValue(getDomainsResult -> getDomainsResult.domains()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:scdn:getDomains
     *       Arguments:
     *         nameRegex: ^my-Domain
     * outputs:
     *   scdnDomainId: ${nameRegex.domains[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomains.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: GetDomainsPlainArgs): GetDomainsResult =
        toKotlin(getDomainsPlain(argument.toJava()).await())

    /**
     * @see [getDomains].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Domain IDs. Its element value is same as Domain Name.
     * @param nameRegex A regex string to filter results by Domain name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The Resource Group ID.
     * @param status The status of the resource. Valid values: "check_failed", "checking", "configure_failed", "configuring", "offline", "online".
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
    ): GetDomainsResult {
        val argument = GetDomainsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
        )
        return toKotlin(getDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;scdn&#46;kotlin&#46;inputs&#46;GetDomainsPlainArgs].
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: suspend GetDomainsPlainArgsBuilder.() -> Unit): GetDomainsResult {
        val builder = GetDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getDomainsPlain(builtArgument.toJava()).await())
    }
}
