@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin.inputs

import com.pulumi.alicloud.scdn.inputs.DomainCertInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certName If You Enable HTTPS Here Certificate Name.
 * @property certType Certificate Type. Value Range:
 * * upload: Certificate
 * * cas: Certificate Authority Certificate.
 * * free: Free Certificate.
 * @property sslPri Private Key. Do Not Enable Certificate without Entering a User Name and Configure Certificates Enter Private Key.
 * @property sslProtocol Whether to Enable SSL Certificate. Valid Values: on, off. Valid values: `on`, `off`.
 * @property sslPub If You Enable HTTPS Here Key.
 */
public data class DomainCertInfoArgs(
    public val certName: Output<String>? = null,
    public val certType: Output<String>? = null,
    public val sslPri: Output<String>? = null,
    public val sslProtocol: Output<String>? = null,
    public val sslPub: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.scdn.inputs.DomainCertInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.scdn.inputs.DomainCertInfoArgs =
        com.pulumi.alicloud.scdn.inputs.DomainCertInfoArgs.builder()
            .certName(certName?.applyValue({ args0 -> args0 }))
            .certType(certType?.applyValue({ args0 -> args0 }))
            .sslPri(sslPri?.applyValue({ args0 -> args0 }))
            .sslProtocol(sslProtocol?.applyValue({ args0 -> args0 }))
            .sslPub(sslPub?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainCertInfoArgs].
 */
@PulumiTagMarker
public class DomainCertInfoArgsBuilder internal constructor() {
    private var certName: Output<String>? = null

    private var certType: Output<String>? = null

    private var sslPri: Output<String>? = null

    private var sslProtocol: Output<String>? = null

    private var sslPub: Output<String>? = null

    /**
     * @param value If You Enable HTTPS Here Certificate Name.
     */
    @JvmName("winjtvspleuabstn")
    public suspend fun certName(`value`: Output<String>) {
        this.certName = value
    }

    /**
     * @param value Certificate Type. Value Range:
     * * upload: Certificate
     * * cas: Certificate Authority Certificate.
     * * free: Free Certificate.
     */
    @JvmName("uomueqjcnighxpye")
    public suspend fun certType(`value`: Output<String>) {
        this.certType = value
    }

    /**
     * @param value Private Key. Do Not Enable Certificate without Entering a User Name and Configure Certificates Enter Private Key.
     */
    @JvmName("unmmnpqhuhfntlaq")
    public suspend fun sslPri(`value`: Output<String>) {
        this.sslPri = value
    }

    /**
     * @param value Whether to Enable SSL Certificate. Valid Values: on, off. Valid values: `on`, `off`.
     */
    @JvmName("nnfgpeguscmsjguq")
    public suspend fun sslProtocol(`value`: Output<String>) {
        this.sslProtocol = value
    }

    /**
     * @param value If You Enable HTTPS Here Key.
     */
    @JvmName("wbafmblhohrrqtjr")
    public suspend fun sslPub(`value`: Output<String>) {
        this.sslPub = value
    }

    /**
     * @param value If You Enable HTTPS Here Certificate Name.
     */
    @JvmName("ssuktapqqkrydlcm")
    public suspend fun certName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certName = mapped
    }

    /**
     * @param value Certificate Type. Value Range:
     * * upload: Certificate
     * * cas: Certificate Authority Certificate.
     * * free: Free Certificate.
     */
    @JvmName("cwskvktyldnxnjmj")
    public suspend fun certType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certType = mapped
    }

    /**
     * @param value Private Key. Do Not Enable Certificate without Entering a User Name and Configure Certificates Enter Private Key.
     */
    @JvmName("cighhtwlaptlpovn")
    public suspend fun sslPri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPri = mapped
    }

    /**
     * @param value Whether to Enable SSL Certificate. Valid Values: on, off. Valid values: `on`, `off`.
     */
    @JvmName("pfmkjafedvaehqpf")
    public suspend fun sslProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslProtocol = mapped
    }

    /**
     * @param value If You Enable HTTPS Here Key.
     */
    @JvmName("uueeavxwnahpjvtm")
    public suspend fun sslPub(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPub = mapped
    }

    internal fun build(): DomainCertInfoArgs = DomainCertInfoArgs(
        certName = certName,
        certType = certType,
        sslPri = sslPri,
        sslProtocol = sslProtocol,
        sslPub = sslPub,
    )
}
