@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin.inputs

import com.pulumi.alicloud.scdn.inputs.DomainConfigFunctionArgArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property argName The name of arg.
 * @property argValue The value of arg.
 */
public data class DomainConfigFunctionArgArgs(
    public val argName: Output<String>,
    public val argValue: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.scdn.inputs.DomainConfigFunctionArgArgs> {
    override fun toJava(): com.pulumi.alicloud.scdn.inputs.DomainConfigFunctionArgArgs =
        com.pulumi.alicloud.scdn.inputs.DomainConfigFunctionArgArgs.builder()
            .argName(argName.applyValue({ args0 -> args0 }))
            .argValue(argValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainConfigFunctionArgArgs].
 */
@PulumiTagMarker
public class DomainConfigFunctionArgArgsBuilder internal constructor() {
    private var argName: Output<String>? = null

    private var argValue: Output<String>? = null

    /**
     * @param value The name of arg.
     */
    @JvmName("qyhluepirfnhahgj")
    public suspend fun argName(`value`: Output<String>) {
        this.argName = value
    }

    /**
     * @param value The value of arg.
     */
    @JvmName("pimskhepenmkwmyu")
    public suspend fun argValue(`value`: Output<String>) {
        this.argValue = value
    }

    /**
     * @param value The name of arg.
     */
    @JvmName("vewdlnoawmnvhwiy")
    public suspend fun argName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.argName = mapped
    }

    /**
     * @param value The value of arg.
     */
    @JvmName("xqkvfdlvkhghcwym")
    public suspend fun argValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.argValue = mapped
    }

    internal fun build(): DomainConfigFunctionArgArgs = DomainConfigFunctionArgArgs(
        argName = argName ?: throw PulumiNullFieldException("argName"),
        argValue = argValue ?: throw PulumiNullFieldException("argValue"),
    )
}
