@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin.inputs

import com.pulumi.alicloud.scdn.inputs.DomainSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The Back-to-Source Address.
 * @property enabled The source status. Valid values: online, offline.
 * @property port Port.
 * @property priority Priority.
 * @property type The Origin Server Type. Valid Values:
 * * ipaddr: IP Source Station
 * * domain: the Domain Name
 * * oss: OSS Bucket as a Source Station.
 */
public data class DomainSourceArgs(
    public val content: Output<String>,
    public val enabled: Output<String>? = null,
    public val port: Output<Int>,
    public val priority: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.scdn.inputs.DomainSourceArgs> {
    override fun toJava(): com.pulumi.alicloud.scdn.inputs.DomainSourceArgs =
        com.pulumi.alicloud.scdn.inputs.DomainSourceArgs.builder()
            .content(content.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainSourceArgs].
 */
@PulumiTagMarker
public class DomainSourceArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var enabled: Output<String>? = null

    private var port: Output<Int>? = null

    private var priority: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The Back-to-Source Address.
     */
    @JvmName("qhdalhnfwjssuenk")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The source status. Valid values: online, offline.
     */
    @JvmName("ecjithjaucparovq")
    public suspend fun enabled(`value`: Output<String>) {
        this.enabled = value
    }

    /**
     * @param value Port.
     */
    @JvmName("kmpgpguwbvhhfuqs")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Priority.
     */
    @JvmName("fooegjfwotsbalyr")
    public suspend fun priority(`value`: Output<String>) {
        this.priority = value
    }

    /**
     * @param value The Origin Server Type. Valid Values:
     * * ipaddr: IP Source Station
     * * domain: the Domain Name
     * * oss: OSS Bucket as a Source Station.
     */
    @JvmName("gacrffhircoooqcv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Back-to-Source Address.
     */
    @JvmName("vjwoxatludswfasx")
    public suspend fun content(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The source status. Valid values: online, offline.
     */
    @JvmName("wtrxhmgnjjyjojlq")
    public suspend fun enabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Port.
     */
    @JvmName("xfevoemkmyfukyhp")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Priority.
     */
    @JvmName("kwxedcggdpnlycxy")
    public suspend fun priority(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The Origin Server Type. Valid Values:
     * * ipaddr: IP Source Station
     * * domain: the Domain Name
     * * oss: OSS Bucket as a Source Station.
     */
    @JvmName("twlnrxmiepysfwkq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DomainSourceArgs = DomainSourceArgs(
        content = content ?: throw PulumiNullFieldException("content"),
        enabled = enabled,
        port = port ?: throw PulumiNullFieldException("port"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
