@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin.inputs

import com.pulumi.alicloud.scdn.inputs.GetDomainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomains.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Domain IDs. Its element value is same as Domain Name.
 * @property nameRegex A regex string to filter results by Domain name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The Resource Group ID.
 * @property status The status of the resource. Valid values: "check_failed", "checking", "configure_failed", "configuring", "offline", "online".
 */
public data class GetDomainsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.scdn.inputs.GetDomainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.scdn.inputs.GetDomainsPlainArgs =
        com.pulumi.alicloud.scdn.inputs.GetDomainsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainsPlainArgs].
 */
@PulumiTagMarker
public class GetDomainsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("odcwpthvisebdlkw")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Domain IDs. Its element value is same as Domain Name.
     */
    @JvmName("parlkwxyxxjpykpw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Domain IDs. Its element value is same as Domain Name.
     */
    @JvmName("rviddpprvpvgpqrm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Domain name.
     */
    @JvmName("sijedahdcpdidghv")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qrxyfqybhudtsuiy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Resource Group ID.
     */
    @JvmName("yfugrvdbvxseeomr")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of the resource. Valid values: "check_failed", "checking", "configure_failed", "configuring", "offline", "online".
     */
    @JvmName("ogabgkikemgsnhog")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDomainsPlainArgs = GetDomainsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        status = status,
    )
}
