@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certName If You Enable HTTPS Here Certificate Name.
 * @property certType Certificate Type. Value Range:
 * * upload: Certificate
 * * cas: Certificate Authority Certificate.
 * * free: Free Certificate.
 * @property sslPri Private Key. Do Not Enable Certificate without Entering a User Name and Configure Certificates Enter Private Key.
 * @property sslProtocol Whether to Enable SSL Certificate. Valid Values: on, off. Valid values: `on`, `off`.
 * @property sslPub If You Enable HTTPS Here Key.
 */
public data class DomainCertInfo(
    public val certName: String? = null,
    public val certType: String? = null,
    public val sslPri: String? = null,
    public val sslProtocol: String? = null,
    public val sslPub: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.scdn.outputs.DomainCertInfo): DomainCertInfo =
            DomainCertInfo(
                certName = javaType.certName().map({ args0 -> args0 }).orElse(null),
                certType = javaType.certType().map({ args0 -> args0 }).orElse(null),
                sslPri = javaType.sslPri().map({ args0 -> args0 }).orElse(null),
                sslProtocol = javaType.sslProtocol().map({ args0 -> args0 }).orElse(null),
                sslPub = javaType.sslPub().map({ args0 -> args0 }).orElse(null),
            )
    }
}
