@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The Back-to-Source Address.
 * @property enabled The source status. Valid values: online, offline.
 * @property port Port.
 * @property priority Priority.
 * @property type The Origin Server Type. Valid Values:
 * * ipaddr: IP Source Station
 * * domain: the Domain Name
 * * oss: OSS Bucket as a Source Station.
 */
public data class DomainSource(
    public val content: String,
    public val enabled: String? = null,
    public val port: Int,
    public val priority: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.scdn.outputs.DomainSource): DomainSource =
            DomainSource(
                content = javaType.content(),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                port = javaType.port(),
                priority = javaType.priority(),
                type = javaType.type(),
            )
    }
}
