@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property certInfos Certificate Information.
 * @property cname In Order to Link the CDN Domain Name to Generate a CNAME Domain Name, in the Domain Name Resolution Service Provider at the Acceleration Domain Name CNAME Resolution to the Domain.
 * @property createTime Creation Time.
 * @property description Review the Reason for the Failure Is Displayed.
 * @property domainName Your Domain Name.
 * @property gmtModified Last Modified Date.
 * @property id The ID of the Domain. Its value is same as Queue Name.
 * @property resourceGroupId The Resource Group ID.
 * @property sources the Origin Server Information.
 * @property status The status of the resource.
 */
public data class GetDomainsDomain(
    public val certInfos: List<GetDomainsDomainCertInfo>,
    public val cname: String,
    public val createTime: String,
    public val description: String,
    public val domainName: String,
    public val gmtModified: String,
    public val id: String,
    public val resourceGroupId: String,
    public val sources: List<GetDomainsDomainSource>,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.scdn.outputs.GetDomainsDomain): GetDomainsDomain = GetDomainsDomain(
            certInfos = javaType.certInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.scdn.kotlin.outputs.GetDomainsDomainCertInfo.Companion.toKotlin(args0)
                })
            }),
            cname = javaType.cname(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            domainName = javaType.domainName(),
            gmtModified = javaType.gmtModified(),
            id = javaType.id(),
            resourceGroupId = javaType.resourceGroupId(),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.scdn.kotlin.outputs.GetDomainsDomainSource.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
        )
    }
}
