@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certName If You Enable HTTPS Here Certificate Name.
 * @property certType Certificate Type. Value Range: Upload: Certificate. CAS: Certificate Authority Certificate. Free: Free Certificate.
 * @property sslProtocol Whether to Enable SSL Certificate. Valid Values: on, off.
 * @property sslPub If You Enable HTTPS Here Key.
 */
public data class GetDomainsDomainCertInfo(
    public val certName: String,
    public val certType: String,
    public val sslProtocol: String,
    public val sslPub: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.scdn.outputs.GetDomainsDomainCertInfo): GetDomainsDomainCertInfo = GetDomainsDomainCertInfo(
            certName = javaType.certName(),
            certType = javaType.certType(),
            sslProtocol = javaType.sslProtocol(),
            sslPub = javaType.sslPub(),
        )
    }
}
