@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.scdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The Back-to-Source Address.
 * @property enabled State.
 * @property port Port.
 * @property priority Priority.
 * @property type the Origin Server Type. Valid Values: Ipaddr: IP Source Station Domain: the Domain Name, See Extra Domain Quota OSS: OSS Bucket as a Source Station.
 */
public data class GetDomainsDomainSource(
    public val content: String,
    public val enabled: String,
    public val port: Int,
    public val priority: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.scdn.outputs.GetDomainsDomainSource): GetDomainsDomainSource = GetDomainsDomainSource(
            content = javaType.content(),
            enabled = javaType.enabled(),
            port = javaType.port(),
            priority = javaType.priority(),
            type = javaType.type(),
        )
    }
}
