@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.schedulerx.kotlin

import com.pulumi.alicloud.schedulerx.NamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Schedulerx Namespace resource.
 * For information about Schedulerx Namespace and how to use it, see [What is Namespace](https://help.aliyun.com/document_detail/206088.html).
 * > **NOTE:** Available in v1.173.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.schedulerx.Namespace("example", {namespaceName: "example_value"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.schedulerx.Namespace("example", namespace_name="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.SchedulerX.Namespace("example", new()
 *     {
 *         NamespaceName = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/schedulerx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := schedulerx.NewNamespace(ctx, "example", &schedulerx.NamespaceArgs{
 * 			NamespaceName: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.schedulerx.Namespace;
 * import com.pulumi.alicloud.schedulerx.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .namespaceName("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:schedulerx:Namespace
 *     properties:
 *       namespaceName: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Schedulerx Namespace can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:schedulerx/namespace:Namespace example <id>
 * ```
 * @property description The description of the resource.
 * @property namespaceName The name of the resource.
 */
public data class NamespaceArgs(
    public val description: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.schedulerx.NamespaceArgs> {
    override fun toJava(): com.pulumi.alicloud.schedulerx.NamespaceArgs =
        com.pulumi.alicloud.schedulerx.NamespaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var namespaceName: Output<String>? = null

    /**
     * @param value The description of the resource.
     */
    @JvmName("fdjdneiprvbmsqgx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("ydrisoieetqjoyam")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The description of the resource.
     */
    @JvmName("lxqewdggsvefryib")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("kcmmsjayukdwvymf")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        description = description,
        namespaceName = namespaceName,
    )
}
