@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.schedulerx.kotlin

import com.pulumi.alicloud.schedulerx.SchedulerxFunctions.getNamespacesPlain
import com.pulumi.alicloud.schedulerx.kotlin.inputs.GetNamespacesPlainArgs
import com.pulumi.alicloud.schedulerx.kotlin.inputs.GetNamespacesPlainArgsBuilder
import com.pulumi.alicloud.schedulerx.kotlin.outputs.GetNamespacesResult
import com.pulumi.alicloud.schedulerx.kotlin.outputs.GetNamespacesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object SchedulerxFunctions {
    /**
     * This data source provides the Schedulerx Namespaces of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.173.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.schedulerx.getNamespaces({});
     * export const schedulerxNamespaceId1 = ids.then(ids => ids.namespaces?.[0]?.id);
     * const nameRegex = alicloud.schedulerx.getNamespaces({
     *     nameRegex: "^my-Namespace",
     * });
     * export const schedulerxNamespaceId2 = nameRegex.then(nameRegex => nameRegex.namespaces?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.schedulerx.get_namespaces()
     * pulumi.export("schedulerxNamespaceId1", ids.namespaces[0].id)
     * name_regex = alicloud.schedulerx.get_namespaces(name_regex="^my-Namespace")
     * pulumi.export("schedulerxNamespaceId2", name_regex.namespaces[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.SchedulerX.GetNamespaces.Invoke();
     *     var nameRegex = AliCloud.SchedulerX.GetNamespaces.Invoke(new()
     *     {
     *         NameRegex = "^my-Namespace",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["schedulerxNamespaceId1"] = ids&#46;Apply(getNamespacesResult => getNamespacesResult&#46;Namespaces[0]?.Id),
     *         ["schedulerxNamespaceId2"] = nameRegex&#46;Apply(getNamespacesResult => getNamespacesResult&#46;Namespaces[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/schedulerx"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := schedulerx.GetNamespaces(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("schedulerxNamespaceId1", ids.Namespaces[0].Id)
     * 		nameRegex, err := schedulerx.GetNamespaces(ctx, &schedulerx.GetNamespacesArgs{
     * 			NameRegex: pulumi.StringRef("^my-Namespace"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("schedulerxNamespaceId2", nameRegex.Namespaces[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.schedulerx.SchedulerxFunctions;
     * import com.pulumi.alicloud.schedulerx.inputs.GetNamespacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SchedulerxFunctions.getNamespaces();
     *         ctx.export("schedulerxNamespaceId1", ids.applyValue(getNamespacesResult -> getNamespacesResult.namespaces()[0].id()));
     *         final var nameRegex = SchedulerxFunctions.getNamespaces(GetNamespacesArgs.builder()
     *             .nameRegex("^my-Namespace")
     *             .build());
     *         ctx.export("schedulerxNamespaceId2", nameRegex.applyValue(getNamespacesResult -> getNamespacesResult.namespaces()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:schedulerx:getNamespaces
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:schedulerx:getNamespaces
     *       Arguments:
     *         nameRegex: ^my-Namespace
     * outputs:
     *   schedulerxNamespaceId1: ${ids.namespaces[0].id}
     *   schedulerxNamespaceId2: ${nameRegex.namespaces[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNamespaces.
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(argument: GetNamespacesPlainArgs): GetNamespacesResult =
        toKotlin(getNamespacesPlain(argument.toJava()).await())

    /**
     * @see [getNamespaces].
     * @param ids A list of Namespace IDs.
     * @param nameRegex A regex string to filter results by Namespace name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetNamespacesResult {
        val argument = GetNamespacesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return toKotlin(getNamespacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;schedulerx&#46;kotlin&#46;inputs&#46;GetNamespacesPlainArgs].
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(argument: suspend GetNamespacesPlainArgsBuilder.() -> Unit): GetNamespacesResult {
        val builder = GetNamespacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getNamespacesPlain(builtArgument.toJava()).await())
    }
}
