@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Config].
 */
@PulumiTagMarker
public class ConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigArgs = ConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigArgsBuilder.() -> Unit) {
        val builder = ConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Config {
        val builtJavaResource = com.pulumi.alicloud.sddp.Config(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Config(builtJavaResource)
    }
}

/**
 * Provides a Data Security Center Config resource.
 * For information about Data Security Center Config and how to use it, see [What is Config](https://www.alibabacloud.com/help/en/data-security-center/latest/api-sddp-2019-01-03-createconfig).
 * > **NOTE:** Available since v1.133.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.sddp.Config("default", {
 *     code: "access_failed_cnt",
 *     value: "10",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.sddp.Config("default",
 *     code="access_failed_cnt",
 *     value="10")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Sddp.Config("default", new()
 *     {
 *         Code = "access_failed_cnt",
 *         Value = "10",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sddp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sddp.NewConfig(ctx, "default", &sddp.ConfigArgs{
 * 			Code:  pulumi.String("access_failed_cnt"),
 * 			Value: pulumi.String("10"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.sddp.Config;
 * import com.pulumi.alicloud.sddp.ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Config("default", ConfigArgs.builder()
 *             .code("access_failed_cnt")
 *             .value(10)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:sddp:Config
 *     properties:
 *       code: access_failed_cnt
 *       value: 10
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Data Security Center Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sddp/config:Config example <code>
 * ```
 */
public class Config internal constructor(
    override val javaResource: com.pulumi.alicloud.sddp.Config,
) : KotlinCustomResource(javaResource, ConfigMapper) {
    /**
     * Abnormal Alarm General Configuration Module by Using the Encoding. Valid values: `access_failed_cnt`, `access_permission_exprie_max_days`, `log_datasize_avg_days`.
     */
    public val code: Output<String>?
        get() = javaResource.code().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Abnormal Alarm General Description of the Configuration Item.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The language of the request and response. Valid values: `zh`,`en`.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Specified Exception Alarm Generic by Using the Value. Code Different Values for This Parameter the Specific Meaning of Different:
     */
    public val `value`: Output<String>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ConfigMapper : ResourceMapper<Config> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.sddp.Config::class == javaResource::class

    override fun map(javaResource: Resource): Config = Config(
        javaResource as
            com.pulumi.alicloud.sddp.Config,
    )
}

/**
 * @see [Config].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Config].
 */
public suspend fun config(name: String, block: suspend ConfigResourceBuilder.() -> Unit): Config {
    val builder = ConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Config].
 * @param name The _unique_ name of the resulting resource.
 */
public fun config(name: String): Config {
    val builder = ConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
