@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin

import com.pulumi.alicloud.sddp.ConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Data Security Center Config resource.
 * For information about Data Security Center Config and how to use it, see [What is Config](https://www.alibabacloud.com/help/en/data-security-center/latest/api-sddp-2019-01-03-createconfig).
 * > **NOTE:** Available since v1.133.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.sddp.Config("default", {
 *     code: "access_failed_cnt",
 *     value: "10",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.sddp.Config("default",
 *     code="access_failed_cnt",
 *     value="10")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Sddp.Config("default", new()
 *     {
 *         Code = "access_failed_cnt",
 *         Value = "10",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sddp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sddp.NewConfig(ctx, "default", &sddp.ConfigArgs{
 * 			Code:  pulumi.String("access_failed_cnt"),
 * 			Value: pulumi.String("10"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.sddp.Config;
 * import com.pulumi.alicloud.sddp.ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Config("default", ConfigArgs.builder()
 *             .code("access_failed_cnt")
 *             .value(10)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:sddp:Config
 *     properties:
 *       code: access_failed_cnt
 *       value: 10
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Data Security Center Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sddp/config:Config example <code>
 * ```
 * @property code Abnormal Alarm General Configuration Module by Using the Encoding. Valid values: `access_failed_cnt`, `access_permission_exprie_max_days`, `log_datasize_avg_days`.
 * @property description Abnormal Alarm General Description of the Configuration Item.
 * @property lang The language of the request and response. Valid values: `zh`,`en`.
 * @property value The Specified Exception Alarm Generic by Using the Value. Code Different Values for This Parameter the Specific Meaning of Different:
 */
public data class ConfigArgs(
    public val code: Output<String>? = null,
    public val description: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sddp.ConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.sddp.ConfigArgs =
        com.pulumi.alicloud.sddp.ConfigArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigArgs].
 */
@PulumiTagMarker
public class ConfigArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var description: Output<String>? = null

    private var lang: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Abnormal Alarm General Configuration Module by Using the Encoding. Valid values: `access_failed_cnt`, `access_permission_exprie_max_days`, `log_datasize_avg_days`.
     */
    @JvmName("enochfscipfktckf")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Abnormal Alarm General Description of the Configuration Item.
     */
    @JvmName("wokkttghcxsifajg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The language of the request and response. Valid values: `zh`,`en`.
     */
    @JvmName("gyovhplfgodukfie")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The Specified Exception Alarm Generic by Using the Value. Code Different Values for This Parameter the Specific Meaning of Different:
     */
    @JvmName("kmgmrbihsiqbtodo")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Abnormal Alarm General Configuration Module by Using the Encoding. Valid values: `access_failed_cnt`, `access_permission_exprie_max_days`, `log_datasize_avg_days`.
     */
    @JvmName("yamxkjvoybstitxg")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Abnormal Alarm General Description of the Configuration Item.
     */
    @JvmName("kpvhevutpvckkcyx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The language of the request and response. Valid values: `zh`,`en`.
     */
    @JvmName("icvwxldfucynpxii")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The Specified Exception Alarm Generic by Using the Value. Code Different Values for This Parameter the Specific Meaning of Different:
     */
    @JvmName("ybutbgrsbalullla")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ConfigArgs = ConfigArgs(
        code = code,
        description = description,
        lang = lang,
        `value` = `value`,
    )
}
