@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DataLimit].
 */
@PulumiTagMarker
public class DataLimitResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataLimitArgs = DataLimitArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataLimitArgsBuilder.() -> Unit) {
        val builder = DataLimitArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataLimit {
        val builtJavaResource = com.pulumi.alicloud.sddp.DataLimit(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataLimit(builtJavaResource)
    }
}

/**
 * Provides a Data Security Center Data Limit resource.
 * For information about Data Security Center Data Limit and how to use it, see [What is Data Limit](https://www.alibabacloud.com/help/en/doc-detail/158987.html).
 * > **NOTE:** Available since v1.159.0.
 * ## Import
 * Data Security Center Data Limit can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sddp/dataLimit:DataLimit example <id>
 * ```
 */
public class DataLimit internal constructor(
    override val javaResource: com.pulumi.alicloud.sddp.DataLimit,
) : KotlinCustomResource(javaResource, DataLimitMapper) {
    /**
     * Whether to enable the log auditing feature. Valid values: `0`, `1`.
     */
    public val auditStatus: Output<Int>
        get() = javaResource.auditStatus().applyValue({ args0 -> args0 })

    /**
     * The type of the database. Valid values: `MySQL`, `SQLServer`.
     */
    public val engineType: Output<String>?
        get() = javaResource.engineType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The lang.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
     */
    public val logStoreDay: Output<Int>?
        get() = javaResource.logStoreDay().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the data asset.
     */
    public val parentId: Output<String>?
        get() = javaResource.parentId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The password that is used to connect to the database.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The port that is used to connect to the database.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * The region ID of the data asset.
     */
    public val serviceRegionId: Output<String>?
        get() = javaResource.serviceRegionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the service to which the data asset belongs.
     */
    public val userName: Output<String>?
        get() = javaResource.userName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object DataLimitMapper : ResourceMapper<DataLimit> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.sddp.DataLimit::class == javaResource::class

    override fun map(javaResource: Resource): DataLimit = DataLimit(
        javaResource as
            com.pulumi.alicloud.sddp.DataLimit,
    )
}

/**
 * @see [DataLimit].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataLimit].
 */
public suspend fun dataLimit(name: String, block: suspend DataLimitResourceBuilder.() -> Unit): DataLimit {
    val builder = DataLimitResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataLimit].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataLimit(name: String): DataLimit {
    val builder = DataLimitResourceBuilder()
    builder.name(name)
    return builder.build()
}
