@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin

import com.pulumi.alicloud.sddp.DataLimitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Data Security Center Data Limit resource.
 * For information about Data Security Center Data Limit and how to use it, see [What is Data Limit](https://www.alibabacloud.com/help/en/doc-detail/158987.html).
 * > **NOTE:** Available since v1.159.0.
 * ## Import
 * Data Security Center Data Limit can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sddp/dataLimit:DataLimit example <id>
 * ```
 * @property auditStatus Whether to enable the log auditing feature. Valid values: `0`, `1`.
 * @property engineType The type of the database. Valid values: `MySQL`, `SQLServer`.
 * @property lang The lang.
 * @property logStoreDay The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
 * @property parentId The ID of the data asset.
 * @property password The password that is used to connect to the database.
 * @property port The port that is used to connect to the database.
 * @property resourceType The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
 * @property serviceRegionId The region ID of the data asset.
 * @property userName The name of the service to which the data asset belongs.
 */
public data class DataLimitArgs(
    public val auditStatus: Output<Int>? = null,
    public val engineType: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val logStoreDay: Output<Int>? = null,
    public val parentId: Output<String>? = null,
    public val password: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val resourceType: Output<String>? = null,
    public val serviceRegionId: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sddp.DataLimitArgs> {
    override fun toJava(): com.pulumi.alicloud.sddp.DataLimitArgs =
        com.pulumi.alicloud.sddp.DataLimitArgs.builder()
            .auditStatus(auditStatus?.applyValue({ args0 -> args0 }))
            .engineType(engineType?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .logStoreDay(logStoreDay?.applyValue({ args0 -> args0 }))
            .parentId(parentId?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .serviceRegionId(serviceRegionId?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataLimitArgs].
 */
@PulumiTagMarker
public class DataLimitArgsBuilder internal constructor() {
    private var auditStatus: Output<Int>? = null

    private var engineType: Output<String>? = null

    private var lang: Output<String>? = null

    private var logStoreDay: Output<Int>? = null

    private var parentId: Output<String>? = null

    private var password: Output<String>? = null

    private var port: Output<Int>? = null

    private var resourceType: Output<String>? = null

    private var serviceRegionId: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Whether to enable the log auditing feature. Valid values: `0`, `1`.
     */
    @JvmName("kdgmyaierlttwtyg")
    public suspend fun auditStatus(`value`: Output<Int>) {
        this.auditStatus = value
    }

    /**
     * @param value The type of the database. Valid values: `MySQL`, `SQLServer`.
     */
    @JvmName("lsjhuwtakkepmwfl")
    public suspend fun engineType(`value`: Output<String>) {
        this.engineType = value
    }

    /**
     * @param value The lang.
     */
    @JvmName("bvcdlnyatmcmkvmi")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
     */
    @JvmName("inisbsyhirockvar")
    public suspend fun logStoreDay(`value`: Output<Int>) {
        this.logStoreDay = value
    }

    /**
     * @param value The ID of the data asset.
     */
    @JvmName("psegpthbpqjejoww")
    public suspend fun parentId(`value`: Output<String>) {
        this.parentId = value
    }

    /**
     * @param value The password that is used to connect to the database.
     */
    @JvmName("bfegpggtpwvaaplf")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The port that is used to connect to the database.
     */
    @JvmName("ajddvbdcowsdasik")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
     */
    @JvmName("vfgyuqdfismrsdin")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The region ID of the data asset.
     */
    @JvmName("wnmhonfyrkrdomit")
    public suspend fun serviceRegionId(`value`: Output<String>) {
        this.serviceRegionId = value
    }

    /**
     * @param value The name of the service to which the data asset belongs.
     */
    @JvmName("nwuneyrpmcwctpra")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Whether to enable the log auditing feature. Valid values: `0`, `1`.
     */
    @JvmName("rghneqvogcsisnyk")
    public suspend fun auditStatus(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditStatus = mapped
    }

    /**
     * @param value The type of the database. Valid values: `MySQL`, `SQLServer`.
     */
    @JvmName("ixxylwcasyldngnd")
    public suspend fun engineType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineType = mapped
    }

    /**
     * @param value The lang.
     */
    @JvmName("jwwllcnvawojocsc")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The retention period of raw logs after you enable the log auditing feature. Unit: day. Valid values: `180`, `30`, `365`, `90`. **NOTE:** The`log_store_day` is valid when the `audit_status` is `1`.
     */
    @JvmName("ghdrllrsmqnurldv")
    public suspend fun logStoreDay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStoreDay = mapped
    }

    /**
     * @param value The ID of the data asset.
     */
    @JvmName("lobuqlalhcdttfet")
    public suspend fun parentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentId = mapped
    }

    /**
     * @param value The password that is used to connect to the database.
     */
    @JvmName("qperbikprfdqkjdf")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The port that is used to connect to the database.
     */
    @JvmName("blmgxnroswbupshd")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
     */
    @JvmName("wanrmgehluwuuvcv")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The region ID of the data asset.
     */
    @JvmName("rifpoalufmumajax")
    public suspend fun serviceRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRegionId = mapped
    }

    /**
     * @param value The name of the service to which the data asset belongs.
     */
    @JvmName("xlnhmgfkfqooeqfw")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): DataLimitArgs = DataLimitArgs(
        auditStatus = auditStatus,
        engineType = engineType,
        lang = lang,
        logStoreDay = logStoreDay,
        parentId = parentId,
        password = password,
        port = port,
        resourceType = resourceType,
        serviceRegionId = serviceRegionId,
        userName = userName,
    )
}
