@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.sddp.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a Data Security Center Instance resource.
 * For information about Data Security Center Instance and how to use it, see [What is Instance](https://help.aliyun.com/product/88674.html).
 * > **NOTE:** Available in v1.136.0+.
 * > **NOTE:** The Data Security Center Instance is not support in the international site.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.sddp.Instance("default", {
 *     paymentType: "Subscription",
 *     sddpVersion: "version_company",
 *     sdCbool: "yes",
 *     period: 1,
 *     sdc: "3",
 *     udCbool: "yes",
 *     udc: "2000",
 *     dataphin: "yes",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.sddp.Instance("default",
 *     payment_type="Subscription",
 *     sddp_version="version_company",
 *     sd_cbool="yes",
 *     period=1,
 *     sdc="3",
 *     ud_cbool="yes",
 *     udc="2000",
 *     dataphin="yes")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Sddp.Instance("default", new()
 *     {
 *         PaymentType = "Subscription",
 *         SddpVersion = "version_company",
 *         SdCbool = "yes",
 *         Period = 1,
 *         Sdc = "3",
 *         UdCbool = "yes",
 *         Udc = "2000",
 *         Dataphin = "yes",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sddp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sddp.NewInstance(ctx, "default", &sddp.InstanceArgs{
 * 			PaymentType: pulumi.String("Subscription"),
 * 			SddpVersion: pulumi.String("version_company"),
 * 			SdCbool:     pulumi.String("yes"),
 * 			Period:      pulumi.Int(1),
 * 			Sdc:         pulumi.String("3"),
 * 			UdCbool:     pulumi.String("yes"),
 * 			Udc:         pulumi.String("2000"),
 * 			Dataphin:    pulumi.String("yes"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.sddp.Instance;
 * import com.pulumi.alicloud.sddp.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .sddpVersion("version_company")
 *             .sdCbool("yes")
 *             .period("1")
 *             .sdc("3")
 *             .udCbool("yes")
 *             .udc("2000")
 *             .dataphin("yes")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:sddp:Instance
 *     properties:
 *       paymentType: Subscription
 *       sddpVersion: version_company
 *       sdCbool: yes
 *       period: '1'
 *       sdc: '3'
 *       udCbool: yes
 *       udc: '2000'
 *       dataphin: yes
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Data Security Center Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sddp/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.sddp.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Whether the required RAM authorization is configured.
     */
    public val authed: Output<Boolean>
        get() = javaResource.authed().applyValue({ args0 -> args0 })

    /**
     * The dataphin. Valid values: `yes`,`no`.
     */
    public val dataphin: Output<String>?
        get() = javaResource.dataphin().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The dataphin count. Valid values: 1 to 20.
     */
    public val dataphinCount: Output<String>?
        get() = javaResource.dataphinCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of instances.
     */
    public val instanceNum: Output<String>
        get() = javaResource.instanceNum().applyValue({ args0 -> args0 })

    /**
     * The logistics.
     */
    public val logistics: Output<String>?
        get() = javaResource.logistics().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
     */
    public val modifyType: Output<String>?
        get() = javaResource.modifyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the authorized MaxCompute (ODPS) assets.
     */
    public val odpsSet: Output<Boolean>
        get() = javaResource.odpsSet().applyValue({ args0 -> args0 })

    /**
     * Whether the authorized oss assets.
     */
    public val ossBucketSet: Output<Boolean>
        get() = javaResource.ossBucketSet().applyValue({ args0 -> args0 })

    /**
     * The OSS storage capacity.
     */
    public val ossSize: Output<String>
        get() = javaResource.ossSize().applyValue({ args0 -> args0 })

    /**
     * The payment type of the resource. Valid values: `Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * Whether the authorized rds assets.
     */
    public val rdsSet: Output<Boolean>
        get() = javaResource.rdsSet().applyValue({ args0 -> args0 })

    /**
     * The remaining days of the protection period of the assets in the current login account.
     */
    public val remainDays: Output<String>
        get() = javaResource.remainDays().applyValue({ args0 -> args0 })

    /**
     * Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
     */
    public val renewPeriod: Output<Int>?
        get() = javaResource.renewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    /**
     * Whether to use the database. Valid values:`yes`,`no`.
     */
    public val sdCbool: Output<String>
        get() = javaResource.sdCbool().applyValue({ args0 -> args0 })

    /**
     * The number of instances.
     */
    public val sdc: Output<String>
        get() = javaResource.sdc().applyValue({ args0 -> args0 })

    /**
     * The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
     */
    public val sddpVersion: Output<String>
        get() = javaResource.sddpVersion().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Whether to use OSS. Valid values: `yes`,`no`.
     */
    public val udCbool: Output<String>
        get() = javaResource.udCbool().applyValue({ args0 -> args0 })

    /**
     * OSS Size.
     */
    public val udc: Output<String>
        get() = javaResource.udc().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.sddp.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.sddp.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
