@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin

import com.pulumi.alicloud.sddp.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Data Security Center Instance resource.
 * For information about Data Security Center Instance and how to use it, see [What is Instance](https://help.aliyun.com/product/88674.html).
 * > **NOTE:** Available in v1.136.0+.
 * > **NOTE:** The Data Security Center Instance is not support in the international site.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.sddp.Instance("default", {
 *     paymentType: "Subscription",
 *     sddpVersion: "version_company",
 *     sdCbool: "yes",
 *     period: 1,
 *     sdc: "3",
 *     udCbool: "yes",
 *     udc: "2000",
 *     dataphin: "yes",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.sddp.Instance("default",
 *     payment_type="Subscription",
 *     sddp_version="version_company",
 *     sd_cbool="yes",
 *     period=1,
 *     sdc="3",
 *     ud_cbool="yes",
 *     udc="2000",
 *     dataphin="yes")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Sddp.Instance("default", new()
 *     {
 *         PaymentType = "Subscription",
 *         SddpVersion = "version_company",
 *         SdCbool = "yes",
 *         Period = 1,
 *         Sdc = "3",
 *         UdCbool = "yes",
 *         Udc = "2000",
 *         Dataphin = "yes",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sddp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sddp.NewInstance(ctx, "default", &sddp.InstanceArgs{
 * 			PaymentType: pulumi.String("Subscription"),
 * 			SddpVersion: pulumi.String("version_company"),
 * 			SdCbool:     pulumi.String("yes"),
 * 			Period:      pulumi.Int(1),
 * 			Sdc:         pulumi.String("3"),
 * 			UdCbool:     pulumi.String("yes"),
 * 			Udc:         pulumi.String("2000"),
 * 			Dataphin:    pulumi.String("yes"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.sddp.Instance;
 * import com.pulumi.alicloud.sddp.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .sddpVersion("version_company")
 *             .sdCbool("yes")
 *             .period("1")
 *             .sdc("3")
 *             .udCbool("yes")
 *             .udc("2000")
 *             .dataphin("yes")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:sddp:Instance
 *     properties:
 *       paymentType: Subscription
 *       sddpVersion: version_company
 *       sdCbool: yes
 *       period: '1'
 *       sdc: '3'
 *       udCbool: yes
 *       udc: '2000'
 *       dataphin: yes
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Data Security Center Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sddp/instance:Instance example <id>
 * ```
 * @property dataphin The dataphin. Valid values: `yes`,`no`.
 * @property dataphinCount The dataphin count. Valid values: 1 to 20.
 * @property logistics The logistics.
 * @property modifyType The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
 * @property ossSize The OSS storage capacity.
 * @property paymentType The payment type of the resource. Valid values: `Subscription`.
 * @property period The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
 * @property renewPeriod Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
 * @property renewalStatus Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
 * @property sdCbool Whether to use the database. Valid values:`yes`,`no`.
 * @property sdc The number of instances.
 * @property sddpVersion The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
 * @property udCbool Whether to use OSS. Valid values: `yes`,`no`.
 * @property udc OSS Size.
 */
public data class InstanceArgs(
    public val dataphin: Output<String>? = null,
    public val dataphinCount: Output<String>? = null,
    public val logistics: Output<String>? = null,
    public val modifyType: Output<String>? = null,
    public val ossSize: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val renewPeriod: Output<Int>? = null,
    public val renewalStatus: Output<String>? = null,
    public val sdCbool: Output<String>? = null,
    public val sdc: Output<String>? = null,
    public val sddpVersion: Output<String>? = null,
    public val udCbool: Output<String>? = null,
    public val udc: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sddp.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.sddp.InstanceArgs =
        com.pulumi.alicloud.sddp.InstanceArgs.builder()
            .dataphin(dataphin?.applyValue({ args0 -> args0 }))
            .dataphinCount(dataphinCount?.applyValue({ args0 -> args0 }))
            .logistics(logistics?.applyValue({ args0 -> args0 }))
            .modifyType(modifyType?.applyValue({ args0 -> args0 }))
            .ossSize(ossSize?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .sdCbool(sdCbool?.applyValue({ args0 -> args0 }))
            .sdc(sdc?.applyValue({ args0 -> args0 }))
            .sddpVersion(sddpVersion?.applyValue({ args0 -> args0 }))
            .udCbool(udCbool?.applyValue({ args0 -> args0 }))
            .udc(udc?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var dataphin: Output<String>? = null

    private var dataphinCount: Output<String>? = null

    private var logistics: Output<String>? = null

    private var modifyType: Output<String>? = null

    private var ossSize: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewalStatus: Output<String>? = null

    private var sdCbool: Output<String>? = null

    private var sdc: Output<String>? = null

    private var sddpVersion: Output<String>? = null

    private var udCbool: Output<String>? = null

    private var udc: Output<String>? = null

    /**
     * @param value The dataphin. Valid values: `yes`,`no`.
     */
    @JvmName("diybhjsigcwoaigu")
    public suspend fun dataphin(`value`: Output<String>) {
        this.dataphin = value
    }

    /**
     * @param value The dataphin count. Valid values: 1 to 20.
     */
    @JvmName("ppqknompotcklkeg")
    public suspend fun dataphinCount(`value`: Output<String>) {
        this.dataphinCount = value
    }

    /**
     * @param value The logistics.
     */
    @JvmName("sjuwdkeilnskcvvt")
    public suspend fun logistics(`value`: Output<String>) {
        this.logistics = value
    }

    /**
     * @param value The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
     */
    @JvmName("aciemjogymwqnols")
    public suspend fun modifyType(`value`: Output<String>) {
        this.modifyType = value
    }

    /**
     * @param value The OSS storage capacity.
     */
    @JvmName("pqknrgnvhrevoywv")
    public suspend fun ossSize(`value`: Output<String>) {
        this.ossSize = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`.
     */
    @JvmName("ekmkeonuhvmwjatd")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
     */
    @JvmName("anqyxkfbsiipkndw")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
     */
    @JvmName("rpmmtoejwuqdpxxw")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
     */
    @JvmName("mtyglruanqmbvurg")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value Whether to use the database. Valid values:`yes`,`no`.
     */
    @JvmName("mrctadujiywpdplh")
    public suspend fun sdCbool(`value`: Output<String>) {
        this.sdCbool = value
    }

    /**
     * @param value The number of instances.
     */
    @JvmName("qsmhqdyvstwbtfsx")
    public suspend fun sdc(`value`: Output<String>) {
        this.sdc = value
    }

    /**
     * @param value The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
     */
    @JvmName("ghaucnymyvxtwtgu")
    public suspend fun sddpVersion(`value`: Output<String>) {
        this.sddpVersion = value
    }

    /**
     * @param value Whether to use OSS. Valid values: `yes`,`no`.
     */
    @JvmName("nnwyunsuvfiduumf")
    public suspend fun udCbool(`value`: Output<String>) {
        this.udCbool = value
    }

    /**
     * @param value OSS Size.
     */
    @JvmName("ltrrxhmuboxqwlaw")
    public suspend fun udc(`value`: Output<String>) {
        this.udc = value
    }

    /**
     * @param value The dataphin. Valid values: `yes`,`no`.
     */
    @JvmName("sygkiwcxexrkbrbe")
    public suspend fun dataphin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataphin = mapped
    }

    /**
     * @param value The dataphin count. Valid values: 1 to 20.
     */
    @JvmName("fvjfildswdovbotj")
    public suspend fun dataphinCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataphinCount = mapped
    }

    /**
     * @param value The logistics.
     */
    @JvmName("xjbhfydggrqjllmd")
    public suspend fun logistics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logistics = mapped
    }

    /**
     * @param value The modify type. Valid values: `Upgrade`, `Downgrade`.  **NOTE:** The `modify_type` is required when you execute a update operation.
     */
    @JvmName("csjgrsbnoqnrlcrd")
    public suspend fun modifyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyType = mapped
    }

    /**
     * @param value The OSS storage capacity.
     */
    @JvmName("njgtnmjpobafipex")
    public suspend fun ossSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossSize = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`.
     */
    @JvmName("yopmqdooaeignstq")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The Prepaid period. Valid values: `1`, `2`, `3`, `6`,`12`,`24`.
     */
    @JvmName("hcwklrrrgdcogvvs")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Automatic renewal period. **NOTE:** The `renew_period` is required under the condition that renewal_status is `AutoRenewal`,
     */
    @JvmName("lfhwvyvyphyubhqu")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
     */
    @JvmName("amghajtiofxekjdp")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value Whether to use the database. Valid values:`yes`,`no`.
     */
    @JvmName("uhnenxfqkexqugla")
    public suspend fun sdCbool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sdCbool = mapped
    }

    /**
     * @param value The number of instances.
     */
    @JvmName("aoleltegeampohuo")
    public suspend fun sdc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sdc = mapped
    }

    /**
     * @param value The sddp version. Valid values: `version_audit`,`version_company`,`version_dlp`.
     */
    @JvmName("muvplnciokhgvqwi")
    public suspend fun sddpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sddpVersion = mapped
    }

    /**
     * @param value Whether to use OSS. Valid values: `yes`,`no`.
     */
    @JvmName("npohfhhmqakofsua")
    public suspend fun udCbool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.udCbool = mapped
    }

    /**
     * @param value OSS Size.
     */
    @JvmName("rxoqfnbwrxduwyfe")
    public suspend fun udc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.udc = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        dataphin = dataphin,
        dataphinCount = dataphinCount,
        logistics = logistics,
        modifyType = modifyType,
        ossSize = ossSize,
        paymentType = paymentType,
        period = period,
        renewPeriod = renewPeriod,
        renewalStatus = renewalStatus,
        sdCbool = sdCbool,
        sdc = sdc,
        sddpVersion = sddpVersion,
        udCbool = udCbool,
        udc = udc,
    )
}
