@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Rule].
 */
@PulumiTagMarker
public class RuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleArgs = RuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleArgsBuilder.() -> Unit) {
        val builder = RuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Rule {
        val builtJavaResource = com.pulumi.alicloud.sddp.Rule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Rule(builtJavaResource)
    }
}

/**
 * Provides a Data Security Center Rule resource.
 * For information about Data Security Center Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/data-security-center/latest/api-sddp-2019-01-03-createrule).
 * > **NOTE:** Available since v1.132.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example-name";
 * const _default = new alicloud.sddp.Rule("default", {
 *     ruleName: name,
 *     category: 2,
 *     content: `  [
 *     {
 *       "rule": [
 *         {
 *           "operator": "contains",
 *           "target": "content",
 *           "value": "tf-testACCContent"
 *         }
 *       ],
 *       "ruleRelation": "AND"
 *     }
 *   ]
 * `,
 *     riskLevelId: "4",
 *     productCode: "OSS",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example-name"
 * default = alicloud.sddp.Rule("default",
 *     rule_name=name,
 *     category=2,
 *     content="""  [
 *     {
 *       "rule": [
 *         {
 *           "operator": "contains",
 *           "target": "content",
 *           "value": "tf-testACCContent"
 *         }
 *       ],
 *       "ruleRelation": "AND"
 *     }
 *   ]
 * """,
 *     risk_level_id="4",
 *     product_code="OSS")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example-name";
 *     var @default = new AliCloud.Sddp.Rule("default", new()
 *     {
 *         RuleName = name,
 *         Category = 2,
 *         Content = @"  [
 *     {
 *       ""rule"": [
 *         {
 *           ""operator"": ""contains"",
 *           ""target"": ""content"",
 *           ""value"": ""tf-testACCContent""
 *         }
 *       ],
 *       ""ruleRelation"": ""AND""
 *     }
 *   ]
 * ",
 *         RiskLevelId = "4",
 *         ProductCode = "OSS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sddp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example-name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := sddp.NewRule(ctx, "default", &sddp.RuleArgs{
 * 			RuleName: pulumi.String(name),
 * 			Category: pulumi.Int(2),
 * 			Content: pulumi.String(`  [
 *     {
 *       "rule": [
 *         {
 *           "operator": "contains",
 *           "target": "content",
 *           "value": "tf-testACCContent"
 *         }
 *       ],
 *       "ruleRelation": "AND"
 *     }
 *   ]
 * `),
 * 			RiskLevelId: pulumi.String("4"),
 * 			ProductCode: pulumi.String("OSS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.sddp.Rule;
 * import com.pulumi.alicloud.sddp.RuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example-name");
 *         var default_ = new Rule("default", RuleArgs.builder()
 *             .ruleName(name)
 *             .category("2")
 *             .content("""
 *   [
 *     {
 *       "rule": [
 *         {
 *           "operator": "contains",
 *           "target": "content",
 *           "value": "tf-testACCContent"
 *         }
 *       ],
 *       "ruleRelation": "AND"
 *     }
 *   ]
 *             """)
 *             .riskLevelId("4")
 *             .productCode("OSS")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example-name
 * resources:
 *   default:
 *     type: alicloud:sddp:Rule
 *     properties:
 *       ruleName: ${name}
 *       category: '2'
 *       content: |2
 *           [
 *             {
 *               "rule": [
 *                 {
 *                   "operator": "contains",
 *                   "target": "content",
 *                   "value": "tf-testACCContent"
 *                 }
 *               ],
 *               "ruleRelation": "AND"
 *             }
 *           ]
 *       riskLevelId: '4'
 *       productCode: OSS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Data Security Center Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sddp/rule:Rule example <id>
 * ```
 */
public class Rule internal constructor(
    override val javaResource: com.pulumi.alicloud.sddp.Rule,
) : KotlinCustomResource(javaResource, RuleMapper) {
    /**
     * The content type of the sensitive data detection rule. Valid values:
     */
    public val category: Output<Int>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
     */
    public val content: Output<String>
        get() = javaResource.content().applyValue({ args0 -> args0 })

    /**
     * The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
     */
    public val contentCategory: Output<String>
        get() = javaResource.contentCategory().applyValue({ args0 -> args0 })

    /**
     * The type of the sensitive data detection rule. **NOTE:** From version 1.222.0, `custom_type` cannot be specified when create Rule.
     */
    public val customType: Output<Int>
        get() = javaResource.customType().applyValue({ args0 -> args0 })

    /**
     * The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The language of the content within the request and response. Default value: `zh`. Valid values:
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
     */
    public val productCode: Output<String>?
        get() = javaResource.productCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the service to which the data asset belongs. Valid values:
     */
    public val productId: Output<String>?
        get() = javaResource.productId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
     */
    public val riskLevelId: Output<String>?
        get() = javaResource.riskLevelId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
     */
    public val ruleName: Output<String>
        get() = javaResource.ruleName().applyValue({ args0 -> args0 })

    /**
     * The type of the sensitive data detection rule. Valid values:
     */
    public val ruleType: Output<Int>?
        get() = javaResource.ruleType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
     */
    public val statExpress: Output<String>?
        get() = javaResource.statExpress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
     */
    public val target: Output<String>?
        get() = javaResource.target().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The risk level of the alert that is triggered. Valid values:
     */
    public val warnLevel: Output<Int>?
        get() = javaResource.warnLevel().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object RuleMapper : ResourceMapper<Rule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.sddp.Rule::class == javaResource::class

    override fun map(javaResource: Resource): Rule = Rule(
        javaResource as
            com.pulumi.alicloud.sddp.Rule,
    )
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Rule].
 */
public suspend fun rule(name: String, block: suspend RuleResourceBuilder.() -> Unit): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rule(name: String): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
