@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin

import com.pulumi.alicloud.sddp.RuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Data Security Center Rule resource.
 * For information about Data Security Center Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/data-security-center/latest/api-sddp-2019-01-03-createrule).
 * > **NOTE:** Available since v1.132.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example-name";
 * const _default = new alicloud.sddp.Rule("default", {
 *     ruleName: name,
 *     category: 2,
 *     content: `  [
 *     {
 *       "rule": [
 *         {
 *           "operator": "contains",
 *           "target": "content",
 *           "value": "tf-testACCContent"
 *         }
 *       ],
 *       "ruleRelation": "AND"
 *     }
 *   ]
 * `,
 *     riskLevelId: "4",
 *     productCode: "OSS",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example-name"
 * default = alicloud.sddp.Rule("default",
 *     rule_name=name,
 *     category=2,
 *     content="""  [
 *     {
 *       "rule": [
 *         {
 *           "operator": "contains",
 *           "target": "content",
 *           "value": "tf-testACCContent"
 *         }
 *       ],
 *       "ruleRelation": "AND"
 *     }
 *   ]
 * """,
 *     risk_level_id="4",
 *     product_code="OSS")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example-name";
 *     var @default = new AliCloud.Sddp.Rule("default", new()
 *     {
 *         RuleName = name,
 *         Category = 2,
 *         Content = @"  [
 *     {
 *       ""rule"": [
 *         {
 *           ""operator"": ""contains"",
 *           ""target"": ""content"",
 *           ""value"": ""tf-testACCContent""
 *         }
 *       ],
 *       ""ruleRelation"": ""AND""
 *     }
 *   ]
 * ",
 *         RiskLevelId = "4",
 *         ProductCode = "OSS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sddp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example-name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := sddp.NewRule(ctx, "default", &sddp.RuleArgs{
 * 			RuleName: pulumi.String(name),
 * 			Category: pulumi.Int(2),
 * 			Content: pulumi.String(`  [
 *     {
 *       "rule": [
 *         {
 *           "operator": "contains",
 *           "target": "content",
 *           "value": "tf-testACCContent"
 *         }
 *       ],
 *       "ruleRelation": "AND"
 *     }
 *   ]
 * `),
 * 			RiskLevelId: pulumi.String("4"),
 * 			ProductCode: pulumi.String("OSS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.sddp.Rule;
 * import com.pulumi.alicloud.sddp.RuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example-name");
 *         var default_ = new Rule("default", RuleArgs.builder()
 *             .ruleName(name)
 *             .category("2")
 *             .content("""
 *   [
 *     {
 *       "rule": [
 *         {
 *           "operator": "contains",
 *           "target": "content",
 *           "value": "tf-testACCContent"
 *         }
 *       ],
 *       "ruleRelation": "AND"
 *     }
 *   ]
 *             """)
 *             .riskLevelId("4")
 *             .productCode("OSS")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example-name
 * resources:
 *   default:
 *     type: alicloud:sddp:Rule
 *     properties:
 *       ruleName: ${name}
 *       category: '2'
 *       content: |2
 *           [
 *             {
 *               "rule": [
 *                 {
 *                   "operator": "contains",
 *                   "target": "content",
 *                   "value": "tf-testACCContent"
 *                 }
 *               ],
 *               "ruleRelation": "AND"
 *             }
 *           ]
 *       riskLevelId: '4'
 *       productCode: OSS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Data Security Center Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sddp/rule:Rule example <id>
 * ```
 * @property category The content type of the sensitive data detection rule. Valid values:
 * @property content The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
 * @property contentCategory The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
 * @property description The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
 * @property lang The language of the content within the request and response. Default value: `zh`. Valid values:
 * @property productCode The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
 * @property productId The ID of the service to which the data asset belongs. Valid values:
 * @property riskLevelId The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
 * @property ruleName The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
 * @property ruleType The type of the sensitive data detection rule. Valid values:
 * @property statExpress The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
 * @property status Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
 * @property target The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
 * @property warnLevel The risk level of the alert that is triggered. Valid values:
 */
public data class RuleArgs(
    public val category: Output<Int>? = null,
    public val content: Output<String>? = null,
    public val contentCategory: Output<String>? = null,
    public val description: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val productCode: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val riskLevelId: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val ruleType: Output<Int>? = null,
    public val statExpress: Output<String>? = null,
    public val status: Output<Int>? = null,
    public val target: Output<String>? = null,
    public val warnLevel: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sddp.RuleArgs> {
    override fun toJava(): com.pulumi.alicloud.sddp.RuleArgs =
        com.pulumi.alicloud.sddp.RuleArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .content(content?.applyValue({ args0 -> args0 }))
            .contentCategory(contentCategory?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .riskLevelId(riskLevelId?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .ruleType(ruleType?.applyValue({ args0 -> args0 }))
            .statExpress(statExpress?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 }))
            .warnLevel(warnLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var category: Output<Int>? = null

    private var content: Output<String>? = null

    private var contentCategory: Output<String>? = null

    private var description: Output<String>? = null

    private var lang: Output<String>? = null

    private var productCode: Output<String>? = null

    private var productId: Output<String>? = null

    private var riskLevelId: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var ruleType: Output<Int>? = null

    private var statExpress: Output<String>? = null

    private var status: Output<Int>? = null

    private var target: Output<String>? = null

    private var warnLevel: Output<Int>? = null

    /**
     * @param value The content type of the sensitive data detection rule. Valid values:
     */
    @JvmName("wlqhcmmqyvrspvak")
    public suspend fun category(`value`: Output<Int>) {
        this.category = value
    }

    /**
     * @param value The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
     */
    @JvmName("cwggxnpaapjmstrc")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
     */
    @JvmName("rwhmexawdombonkf")
    public suspend fun contentCategory(`value`: Output<String>) {
        this.contentCategory = value
    }

    /**
     * @param value The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
     */
    @JvmName("wwujdvctkngdubja")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The language of the content within the request and response. Default value: `zh`. Valid values:
     */
    @JvmName("dsqctmyohbhkokbn")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
     */
    @JvmName("imdrgvmvijwryegp")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value The ID of the service to which the data asset belongs. Valid values:
     */
    @JvmName("nfmlidcljcvesoiv")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
     */
    @JvmName("dctxergavxcknmbg")
    public suspend fun riskLevelId(`value`: Output<String>) {
        this.riskLevelId = value
    }

    /**
     * @param value The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
     */
    @JvmName("pwhkjgvdixrhigbl")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The type of the sensitive data detection rule. Valid values:
     */
    @JvmName("dchtiolrqhpshisj")
    public suspend fun ruleType(`value`: Output<Int>) {
        this.ruleType = value
    }

    /**
     * @param value The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
     */
    @JvmName("lnxcgbchlgliocwj")
    public suspend fun statExpress(`value`: Output<String>) {
        this.statExpress = value
    }

    /**
     * @param value Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
     */
    @JvmName("fklvsgwbtmafrinw")
    public suspend fun status(`value`: Output<Int>) {
        this.status = value
    }

    /**
     * @param value The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
     */
    @JvmName("mhglarwnpewcvpvw")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The risk level of the alert that is triggered. Valid values:
     */
    @JvmName("nvifjfneqpyhkydl")
    public suspend fun warnLevel(`value`: Output<Int>) {
        this.warnLevel = value
    }

    /**
     * @param value The content type of the sensitive data detection rule. Valid values:
     */
    @JvmName("qltsbtupgwuscbod")
    public suspend fun category(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
     */
    @JvmName("cihbdgkedxctwgdh")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
     */
    @JvmName("qliqvvjctqduvtrh")
    public suspend fun contentCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentCategory = mapped
    }

    /**
     * @param value The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
     */
    @JvmName("uslmeqjqcgexfqfe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The language of the content within the request and response. Default value: `zh`. Valid values:
     */
    @JvmName("feftajyorgqtrjym")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
     */
    @JvmName("terstecypybqcpfs")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value The ID of the service to which the data asset belongs. Valid values:
     */
    @JvmName("dbhskwvmomnkwblf")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
     */
    @JvmName("pfprsedgwjnqmgth")
    public suspend fun riskLevelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.riskLevelId = mapped
    }

    /**
     * @param value The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
     */
    @JvmName("bimwlmsieieutxdg")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The type of the sensitive data detection rule. Valid values:
     */
    @JvmName("hvdolnqcrenuumea")
    public suspend fun ruleType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
     */
    @JvmName("mivgufkbrambpqru")
    public suspend fun statExpress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statExpress = mapped
    }

    /**
     * @param value Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
     */
    @JvmName("csgafhipsiwlieri")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
     */
    @JvmName("ovsmrywsntpkcicg")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value The risk level of the alert that is triggered. Valid values:
     */
    @JvmName("ekvmhdyvtytxwxbi")
    public suspend fun warnLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warnLevel = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        category = category,
        content = content,
        contentCategory = contentCategory,
        description = description,
        lang = lang,
        productCode = productCode,
        productId = productId,
        riskLevelId = riskLevelId,
        ruleName = ruleName,
        ruleType = ruleType,
        statExpress = statExpress,
        status = status,
        target = target,
        warnLevel = warnLevel,
    )
}
