@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin

import com.pulumi.alicloud.sddp.SddpFunctions.getConfigsPlain
import com.pulumi.alicloud.sddp.SddpFunctions.getDataLimitsPlain
import com.pulumi.alicloud.sddp.SddpFunctions.getInstancesPlain
import com.pulumi.alicloud.sddp.SddpFunctions.getRulesPlain
import com.pulumi.alicloud.sddp.kotlin.inputs.GetConfigsPlainArgs
import com.pulumi.alicloud.sddp.kotlin.inputs.GetConfigsPlainArgsBuilder
import com.pulumi.alicloud.sddp.kotlin.inputs.GetDataLimitsPlainArgs
import com.pulumi.alicloud.sddp.kotlin.inputs.GetDataLimitsPlainArgsBuilder
import com.pulumi.alicloud.sddp.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.sddp.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.sddp.kotlin.inputs.GetRulesPlainArgs
import com.pulumi.alicloud.sddp.kotlin.inputs.GetRulesPlainArgsBuilder
import com.pulumi.alicloud.sddp.kotlin.outputs.GetConfigsResult
import com.pulumi.alicloud.sddp.kotlin.outputs.GetDataLimitsResult
import com.pulumi.alicloud.sddp.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.sddp.kotlin.outputs.GetRulesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.sddp.kotlin.outputs.GetConfigsResult.Companion.toKotlin as getConfigsResultToKotlin
import com.pulumi.alicloud.sddp.kotlin.outputs.GetDataLimitsResult.Companion.toKotlin as getDataLimitsResultToKotlin
import com.pulumi.alicloud.sddp.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.sddp.kotlin.outputs.GetRulesResult.Companion.toKotlin as getRulesResultToKotlin

public object SddpFunctions {
    /**
     * This data source provides the Sddp Configs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.133.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultConfig = new alicloud.sddp.Config("default", {
     *     code: "access_failed_cnt",
     *     value: "10",
     * });
     * const default = alicloud.sddp.getConfigsOutput({
     *     ids: [defaultConfig&#46;id],
     *     outputFile: "./t.json",
     * });
     * export const sddpConfigId = _default.apply(_default => _default.ids);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_config = alicloud.sddp.Config("default",
     *     code="access_failed_cnt",
     *     value="10")
     * default = alicloud.sddp.get_configs_output(ids=[default_config&#46;id],
     *     output_file="./t.json")
     * pulumi.export("sddpConfigId", default.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultConfig = new AliCloud.Sddp.Config("default", new()
     *     {
     *         Code = "access_failed_cnt",
     *         Value = "10",
     *     });
     *     var @default = AliCloud.Sddp.GetConfigs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultConfig.Id,
     *         },
     *         OutputFile = "./t.json",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["sddpConfigId"] = @default.Apply(@default => @default.Apply(getConfigsResult => getConfigsResult.Ids)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sddp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * defaultConfig, err := sddp.NewConfig(ctx, "default", &sddp.ConfigArgs{
     * Code: pulumi.String("access_failed_cnt"),
     * Value: pulumi.String("10"),
     * })
     * if err != nil {
     * return err
     * }
     * _default := sddp.GetConfigsOutput(ctx, sddp.GetConfigsOutputArgs{
     * Ids: pulumi.StringArray{
     * defaultConfig.ID(),
     * },
     * OutputFile: pulumi.String("./t.json"),
     * }, nil);
     * ctx.Export("sddpConfigId", _default.ApplyT(func(_default sddp.GetConfigsResult) (interface{}, error) {
     * return _default.Ids, nil
     * }).(pulumi.Interface{}Output))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sddp.Config;
     * import com.pulumi.alicloud.sddp.ConfigArgs;
     * import com.pulumi.alicloud.sddp.SddpFunctions;
     * import com.pulumi.alicloud.sddp.inputs.GetConfigsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultConfig = new Config("defaultConfig", ConfigArgs.builder()
     *             .code("access_failed_cnt")
     *             .value(10)
     *             .build());
     *         final var default = SddpFunctions.getConfigs(GetConfigsArgs.builder()
     *             .ids(defaultConfig.id())
     *             .outputFile("./t.json")
     *             .build());
     *         ctx.export("sddpConfigId", default_.applyValue(default_ -> default_.ids()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultConfig:
     *     type: alicloud:sddp:Config
     *     name: default
     *     properties:
     *       code: access_failed_cnt
     *       value: 10
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:sddp:getConfigs
     *       Arguments:
     *         ids:
     *           - ${defaultConfig.id}
     *         outputFile: ./t.json
     * outputs:
     *   sddpConfigId: ${default.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConfigs.
     * @return A collection of values returned by getConfigs.
     */
    public suspend fun getConfigs(argument: GetConfigsPlainArgs): GetConfigsResult =
        getConfigsResultToKotlin(getConfigsPlain(argument.toJava()).await())

    /**
     * @see [getConfigs].
     * @param ids A list of Config IDs.
     * @param lang
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getConfigs.
     */
    public suspend fun getConfigs(
        ids: List<String>? = null,
        lang: String? = null,
        outputFile: String? = null,
    ): GetConfigsResult {
        val argument = GetConfigsPlainArgs(
            ids = ids,
            lang = lang,
            outputFile = outputFile,
        )
        return getConfigsResultToKotlin(getConfigsPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sddp&#46;kotlin&#46;inputs&#46;GetConfigsPlainArgs].
     * @return A collection of values returned by getConfigs.
     */
    public suspend fun getConfigs(argument: suspend GetConfigsPlainArgsBuilder.() -> Unit): GetConfigsResult {
        val builder = GetConfigsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigsResultToKotlin(getConfigsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Sddp Data Limits of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.159.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.sddp.getDataLimits({});
     * export const sddpDataLimitId1 = ids.then(ids => ids.limits?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.sddp.get_data_limits()
     * pulumi.export("sddpDataLimitId1", ids.limits[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Sddp.GetDataLimits.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["sddpDataLimitId1"] = ids&#46;Apply(getDataLimitsResult => getDataLimitsResult&#46;Limits[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sddp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := sddp.GetDataLimits(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("sddpDataLimitId1", ids.Limits[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sddp.SddpFunctions;
     * import com.pulumi.alicloud.sddp.inputs.GetDataLimitsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SddpFunctions.getDataLimits();
     *         ctx.export("sddpDataLimitId1", ids.applyValue(getDataLimitsResult -> getDataLimitsResult.limits()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:sddp:getDataLimits
     *       Arguments: {}
     * outputs:
     *   sddpDataLimitId1: ${ids.limits[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDataLimits.
     * @return A collection of values returned by getDataLimits.
     */
    public suspend fun getDataLimits(argument: GetDataLimitsPlainArgs): GetDataLimitsResult =
        getDataLimitsResultToKotlin(getDataLimitsPlain(argument.toJava()).await())

    /**
     * @see [getDataLimits].
     * @param ids A list of Data Limit IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param parentId The parent asset ID of the data asset.
     * @param resourceType The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
     * @return A collection of values returned by getDataLimits.
     */
    public suspend fun getDataLimits(
        ids: List<String>? = null,
        outputFile: String? = null,
        parentId: String? = null,
        resourceType: String? = null,
    ): GetDataLimitsResult {
        val argument = GetDataLimitsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            parentId = parentId,
            resourceType = resourceType,
        )
        return getDataLimitsResultToKotlin(getDataLimitsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataLimits].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sddp&#46;kotlin&#46;inputs&#46;GetDataLimitsPlainArgs].
     * @return A collection of values returned by getDataLimits.
     */
    public suspend fun getDataLimits(argument: suspend GetDataLimitsPlainArgsBuilder.() -> Unit): GetDataLimitsResult {
        val builder = GetDataLimitsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataLimitsResultToKotlin(getDataLimitsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Sddp Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.136.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.sddp.getInstances({});
     * export const sddpInstanceId = _default.then(_default => _default.instances?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.sddp.get_instances()
     * pulumi.export("sddpInstanceId", default.instances[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Sddp.GetInstances.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["sddpInstanceId"] = @default&#46;Apply(@default => @default&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0])),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sddp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := sddp.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("sddpInstanceId", _default.Instances[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sddp.SddpFunctions;
     * import com.pulumi.alicloud.sddp.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = SddpFunctions.getInstances();
     *         ctx.export("sddpInstanceId", default_.instances()[0]);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:sddp:getInstances
     *       Arguments: {}
     * outputs:
     *   sddpInstanceId: ${default.instances[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(outputFile: String? = null): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            outputFile = outputFile,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sddp&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Sddp Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultRule = new alicloud.sddp.Rule("default", {
     *     category: 0,
     *     content: "content",
     *     ruleName: "rule_name",
     *     riskLevelId: "4",
     *     productCode: "ODPS",
     * });
     * const default = alicloud.sddp.getRulesOutput({
     *     ids: [defaultRule&#46;id],
     * });
     * export const sddpRuleId = _default.apply(_default => _default.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_rule = alicloud.sddp.Rule("default",
     *     category=0,
     *     content="content",
     *     rule_name="rule_name",
     *     risk_level_id="4",
     *     product_code="ODPS")
     * default = alicloud.sddp.get_rules_output(ids=[default_rule&#46;id])
     * pulumi.export("sddpRuleId", default.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultRule = new AliCloud.Sddp.Rule("default", new()
     *     {
     *         Category = 0,
     *         Content = "content",
     *         RuleName = "rule_name",
     *         RiskLevelId = "4",
     *         ProductCode = "ODPS",
     *     });
     *     var @default = AliCloud.Sddp.GetRules.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultRule.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["sddpRuleId"] = @default.Apply(@default => @default.Apply(getRulesResult => getRulesResult.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sddp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * defaultRule, err := sddp.NewRule(ctx, "default", &sddp.RuleArgs{
     * Category: pulumi.Int(0),
     * Content: pulumi.String("content"),
     * RuleName: pulumi.String("rule_name"),
     * RiskLevelId: pulumi.String("4"),
     * ProductCode: pulumi.String("ODPS"),
     * })
     * if err != nil {
     * return err
     * }
     * _default := sddp.GetRulesOutput(ctx, sddp.GetRulesOutputArgs{
     * Ids: pulumi.StringArray{
     * defaultRule.ID(),
     * },
     * }, nil);
     * ctx.Export("sddpRuleId", _default.ApplyT(func(_default sddp.GetRulesResult) (*string, error) {
     * return &default.Id, nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sddp.Rule;
     * import com.pulumi.alicloud.sddp.RuleArgs;
     * import com.pulumi.alicloud.sddp.SddpFunctions;
     * import com.pulumi.alicloud.sddp.inputs.GetRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultRule = new Rule("defaultRule", RuleArgs.builder()
     *             .category("0")
     *             .content("content")
     *             .ruleName("rule_name")
     *             .riskLevelId("4")
     *             .productCode("ODPS")
     *             .build());
     *         final var default = SddpFunctions.getRules(GetRulesArgs.builder()
     *             .ids(defaultRule.id())
     *             .build());
     *         ctx.export("sddpRuleId", default_.applyValue(default_ -> default_.id()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultRule:
     *     type: alicloud:sddp:Rule
     *     name: default
     *     properties:
     *       category: '0'
     *       content: content
     *       ruleName: rule_name
     *       riskLevelId: '4'
     *       productCode: ODPS
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:sddp:getRules
     *       Arguments:
     *         ids:
     *           - ${defaultRule.id}
     * outputs:
     *   sddpRuleId: ${default.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRules.
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: GetRulesPlainArgs): GetRulesResult =
        getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())

    /**
     * @see [getRules].
     * @param category Sensitive Data Identification Rules for the Type of. Valid values:
     * @param contentCategory The Content Classification.
     * @param customType Sensitive Data Identification Rules of Type. Valid values:
     * @param enableDetails
     * @param ids A list of Rule IDs.
     * @param name The name of rule.
     * @param nameRegex A regex string to filter results by Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productId Product ID. Valid values:
     * @param riskLevelId Sensitive Data Identification Rules of Risk Level ID. Valid values:
     * @param ruleType Rule Type.
     * @param status Sensitive Data Identification Rules Detection State of.
     * @param warnLevel The Level of Risk. Valid values:
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(
        category: Int? = null,
        contentCategory: String? = null,
        customType: Int? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        name: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        productId: String? = null,
        riskLevelId: String? = null,
        ruleType: Int? = null,
        status: String? = null,
        warnLevel: Int? = null,
    ): GetRulesResult {
        val argument = GetRulesPlainArgs(
            category = category,
            contentCategory = contentCategory,
            customType = customType,
            enableDetails = enableDetails,
            ids = ids,
            name = name,
            nameRegex = nameRegex,
            outputFile = outputFile,
            productId = productId,
            riskLevelId = riskLevelId,
            ruleType = ruleType,
            status = status,
            warnLevel = warnLevel,
        )
        return getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sddp&#46;kotlin&#46;inputs&#46;GetRulesPlainArgs].
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: suspend GetRulesPlainArgsBuilder.() -> Unit): GetRulesResult {
        val builder = GetRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRulesResultToKotlin(getRulesPlain(builtArgument.toJava()).await())
    }
}
