@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin.inputs

import com.pulumi.alicloud.sddp.inputs.GetConfigsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConfigs.
 * @property ids A list of Config IDs.
 * @property lang
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetConfigsPlainArgs(
    public val ids: List<String>? = null,
    public val lang: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sddp.inputs.GetConfigsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.sddp.inputs.GetConfigsPlainArgs =
        com.pulumi.alicloud.sddp.inputs.GetConfigsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lang(lang?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigsPlainArgs].
 */
@PulumiTagMarker
public class GetConfigsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var lang: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Config IDs.
     */
    @JvmName("sfwgahyuadxfmvva")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Config IDs.
     */
    @JvmName("cmqcvrurdfehmens")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("vpdyvrglhqrnasne")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("vewtcdcvcdxaodai")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetConfigsPlainArgs = GetConfigsPlainArgs(
        ids = ids,
        lang = lang,
        outputFile = outputFile,
    )
}
