@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin.inputs

import com.pulumi.alicloud.sddp.inputs.GetDataLimitsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDataLimits.
 * @property ids A list of Data Limit IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property parentId The parent asset ID of the data asset.
 * @property resourceType The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
 */
public data class GetDataLimitsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val parentId: String? = null,
    public val resourceType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sddp.inputs.GetDataLimitsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.sddp.inputs.GetDataLimitsPlainArgs =
        com.pulumi.alicloud.sddp.inputs.GetDataLimitsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .parentId(parentId?.let({ args0 -> args0 }))
            .resourceType(resourceType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataLimitsPlainArgs].
 */
@PulumiTagMarker
public class GetDataLimitsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var parentId: String? = null

    private var resourceType: String? = null

    /**
     * @param value A list of Data Limit IDs.
     */
    @JvmName("rnudmrwviesiujav")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Data Limit IDs.
     */
    @JvmName("jehiohonjkdipqgu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rotlfnekxwcntfbt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The parent asset ID of the data asset.
     */
    @JvmName("hqoymorwxmycwjno")
    public suspend fun parentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parentId = mapped
    }

    /**
     * @param value The type of the service to which the data asset belongs. Valid values: `MaxCompute`, `OSS`, `RDS`.
     */
    @JvmName("ikeucysrjukvblgr")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    internal fun build(): GetDataLimitsPlainArgs = GetDataLimitsPlainArgs(
        ids = ids,
        outputFile = outputFile,
        parentId = parentId,
        resourceType = resourceType,
    )
}
