@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin.inputs

import com.pulumi.alicloud.sddp.inputs.GetRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRules.
 * @property category Sensitive Data Identification Rules for the Type of. Valid values:
 * @property contentCategory The Content Classification.
 * @property customType Sensitive Data Identification Rules of Type. Valid values:
 * @property enableDetails
 * @property ids A list of Rule IDs.
 * @property name The name of rule.
 * @property nameRegex A regex string to filter results by Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property productId Product ID. Valid values:
 * @property riskLevelId Sensitive Data Identification Rules of Risk Level ID. Valid values:
 * @property ruleType Rule Type.
 * @property status Sensitive Data Identification Rules Detection State of.
 * @property warnLevel The Level of Risk. Valid values:
 */
public data class GetRulesPlainArgs(
    public val category: Int? = null,
    public val contentCategory: String? = null,
    public val customType: Int? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val productId: String? = null,
    public val riskLevelId: String? = null,
    public val ruleType: Int? = null,
    public val status: String? = null,
    public val warnLevel: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sddp.inputs.GetRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.sddp.inputs.GetRulesPlainArgs =
        com.pulumi.alicloud.sddp.inputs.GetRulesPlainArgs.builder()
            .category(category?.let({ args0 -> args0 }))
            .contentCategory(contentCategory?.let({ args0 -> args0 }))
            .customType(customType?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productId(productId?.let({ args0 -> args0 }))
            .riskLevelId(riskLevelId?.let({ args0 -> args0 }))
            .ruleType(ruleType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .warnLevel(warnLevel?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRulesPlainArgs].
 */
@PulumiTagMarker
public class GetRulesPlainArgsBuilder internal constructor() {
    private var category: Int? = null

    private var contentCategory: String? = null

    private var customType: Int? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var name: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var productId: String? = null

    private var riskLevelId: String? = null

    private var ruleType: Int? = null

    private var status: String? = null

    private var warnLevel: Int? = null

    /**
     * @param value Sensitive Data Identification Rules for the Type of. Valid values:
     */
    @JvmName("ddmmihpvwhgblisi")
    public suspend fun category(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value The Content Classification.
     */
    @JvmName("kkywcgjglwicswrg")
    public suspend fun contentCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contentCategory = mapped
    }

    /**
     * @param value Sensitive Data Identification Rules of Type. Valid values:
     */
    @JvmName("rwfwqixsovaivgty")
    public suspend fun customType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.customType = mapped
    }

    /**
     * @param value
     */
    @JvmName("coogacihjmfatggv")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Rule IDs.
     */
    @JvmName("pqnftuccqkdhjhye")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Rule IDs.
     */
    @JvmName("jrkhnlyvgulhavhj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of rule.
     */
    @JvmName("ttfxnlwqdhicusou")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value A regex string to filter results by Rule name.
     */
    @JvmName("ulhvqrrnrnikouoc")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ignwdyauydwkvpry")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Product ID. Valid values:
     */
    @JvmName("lbkaxflegpsrylsq")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productId = mapped
    }

    /**
     * @param value Sensitive Data Identification Rules of Risk Level ID. Valid values:
     */
    @JvmName("ofnbavyshjlfyalv")
    public suspend fun riskLevelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.riskLevelId = mapped
    }

    /**
     * @param value Rule Type.
     */
    @JvmName("cqqindhneuifuyvt")
    public suspend fun ruleType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ruleType = mapped
    }

    /**
     * @param value Sensitive Data Identification Rules Detection State of.
     */
    @JvmName("fniyqkyvcgcrucxy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The Level of Risk. Valid values:
     */
    @JvmName("vgasfhwqmtgwdfec")
    public suspend fun warnLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.warnLevel = mapped
    }

    internal fun build(): GetRulesPlainArgs = GetRulesPlainArgs(
        category = category,
        contentCategory = contentCategory,
        customType = customType,
        enableDetails = enableDetails,
        ids = ids,
        name = name,
        nameRegex = nameRegex,
        outputFile = outputFile,
        productId = productId,
        riskLevelId = riskLevelId,
        ruleType = ruleType,
        status = status,
        warnLevel = warnLevel,
    )
}
