@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getConfigs.
 * @property configs
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property lang
 * @property outputFile
 */
public data class GetConfigsResult(
    public val configs: List<GetConfigsConfig>,
    public val id: String,
    public val ids: List<String>,
    public val lang: String? = null,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sddp.outputs.GetConfigsResult): GetConfigsResult = GetConfigsResult(
            configs = javaType.configs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sddp.kotlin.outputs.GetConfigsConfig.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
