@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property auditStatus Whether to enable the log auditing feature.
 * @property checkStatus The status of the connectivity test between the data asset and SDDP.
 * @property dataLimitId The first ID of the resource.
 * @property engineType The type of the database.
 * @property id The ID of the Data Limit.
 * @property localName The name of the service to which the data asset belongs.
 * @property logStoreDay The retention period of raw logs after you enable the log auditing feature.
 * @property parentId The ID of the data asset.
 * @property port The port that is used to connect to the database.
 * @property resourceType The type of the service to which the data asset belongs.
 * @property userName The name of the user who owns the data asset.
 */
public data class GetDataLimitsLimit(
    public val auditStatus: Int,
    public val checkStatus: Int,
    public val dataLimitId: String,
    public val engineType: String,
    public val id: String,
    public val localName: String,
    public val logStoreDay: Int,
    public val parentId: String,
    public val port: Int,
    public val resourceType: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sddp.outputs.GetDataLimitsLimit): GetDataLimitsLimit = GetDataLimitsLimit(
            auditStatus = javaType.auditStatus(),
            checkStatus = javaType.checkStatus(),
            dataLimitId = javaType.dataLimitId(),
            engineType = javaType.engineType(),
            id = javaType.id(),
            localName = javaType.localName(),
            logStoreDay = javaType.logStoreDay(),
            parentId = javaType.parentId(),
            port = javaType.port(),
            resourceType = javaType.resourceType(),
            userName = javaType.userName(),
        )
    }
}
