@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDataLimits.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property limits
 * @property outputFile
 * @property parentId
 * @property resourceType
 */
public data class GetDataLimitsResult(
    public val id: String,
    public val ids: List<String>,
    public val limits: List<GetDataLimitsLimit>,
    public val outputFile: String? = null,
    public val parentId: String? = null,
    public val resourceType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sddp.outputs.GetDataLimitsResult): GetDataLimitsResult = GetDataLimitsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            limits = javaType.limits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sddp.kotlin.outputs.GetDataLimitsLimit.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            parentId = javaType.parentId().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
