@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authed Whether the required RAM authorization is configured.
 * @property id
 * @property instanceId The ID of the instance.
 * @property instanceNum The number of instances.
 * @property odpsSet Whether the authorized MaxCompute (ODPS) assets.
 * @property ossBucketSet Whether the authorized oss assets.
 * @property ossSize The OSS size of the instance.
 * @property paymentType The payment type of the resource. Valid values: `Subscription`.
 * @property rdsSet Whether the authorized rds assets.
 * @property status The status of the resource.
 */
public data class GetInstancesInstance(
    public val authed: Boolean,
    public val id: String,
    public val instanceId: String,
    public val instanceNum: String,
    public val odpsSet: Boolean,
    public val ossBucketSet: Boolean,
    public val ossSize: String,
    public val paymentType: String,
    public val rdsSet: Boolean,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sddp.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            authed = javaType.authed(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceNum = javaType.instanceNum(),
            odpsSet = javaType.odpsSet(),
            ossBucketSet = javaType.ossBucketSet(),
            ossSize = javaType.ossSize(),
            paymentType = javaType.paymentType(),
            rdsSet = javaType.rdsSet(),
            status = javaType.status(),
        )
    }
}
