@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRules.
 * @property category
 * @property contentCategory
 * @property customType
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property name
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property productId
 * @property riskLevelId
 * @property ruleType
 * @property rules
 * @property status
 * @property warnLevel
 */
public data class GetRulesResult(
    public val category: Int? = null,
    public val contentCategory: String? = null,
    public val customType: Int? = null,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val productId: String? = null,
    public val riskLevelId: String? = null,
    public val ruleType: Int? = null,
    public val rules: List<GetRulesRule>,
    public val status: String? = null,
    public val warnLevel: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sddp.outputs.GetRulesResult): GetRulesResult =
            GetRulesResult(
                category = javaType.category().map({ args0 -> args0 }).orElse(null),
                contentCategory = javaType.contentCategory().map({ args0 -> args0 }).orElse(null),
                customType = javaType.customType().map({ args0 -> args0 }).orElse(null),
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                productId = javaType.productId().map({ args0 -> args0 }).orElse(null),
                riskLevelId = javaType.riskLevelId().map({ args0 -> args0 }).orElse(null),
                ruleType = javaType.ruleType().map({ args0 -> args0 }).orElse(null),
                rules = javaType.rules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.sddp.kotlin.outputs.GetRulesRule.Companion.toKotlin(args0)
                    })
                }),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                warnLevel = javaType.warnLevel().map({ args0 -> args0 }).orElse(null),
            )
    }
}
