@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sddp.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category Sensitive Data Identification Rules for the Type of.
 * @property categoryName Sensitive Data Identification Rules Belongs Type Name.
 * @property content Sensitive Data Identification Rules the Content.
 * @property contentCategory The Content Classification.
 * @property createTime Sensitive Data Identification Rules the Creation Time of the Number of Milliseconds.
 * @property customType Sensitive Data Identification Rules of Type. 0: the Built-in 1: The User-Defined.
 * @property description Sensitive Data Identification a Description of the Rule Information.
 * @property displayName Sensitive Data Identification Rules, Founder of Account Display Name.
 * @property gmtModified Sensitive Data Identification Rules to the Modified Time of the Number of Milliseconds.
 * @property id The ID of the Rule.
 * @property loginName Sensitive Data Identification Rules, Founder Of Account Login.
 * @property majorKey The Primary Key.
 * @property name The name of rule.
 * @property productCode Product Code.
 * @property productId Product ID.
 * @property riskLevelId Sensitive Data Identification Rules of Risk Level ID. Valid values:1:S1, Weak Risk Level. 2:S2, Medium Risk Level. 3:S3 High Risk Level. 4:S4, the Highest Risk Level.
 * @property riskLevelName Sensitive Data Identification Rules the Risk Level of. S1: Weak Risk Level S2: Moderate Risk Level S3: High Risk Level S4: the Highest Risk Level.
 * @property ruleId The first ID of the resource.
 * @property statExpress Triggered the Alarm Conditions.
 * @property status Sensitive Data Identification Rules Detection State of.
 * @property target The Target.
 * @property userId The User ID.
 * @property warnLevel The Level of Risk.
 */
public data class GetRulesRule(
    public val category: Int,
    public val categoryName: String,
    public val content: String,
    public val contentCategory: String,
    public val createTime: String,
    public val customType: Int,
    public val description: String,
    public val displayName: String,
    public val gmtModified: String,
    public val id: String,
    public val loginName: String,
    public val majorKey: String,
    public val name: String,
    public val productCode: String,
    public val productId: String,
    public val riskLevelId: String,
    public val riskLevelName: String,
    public val ruleId: String,
    public val statExpress: String,
    public val status: Int,
    public val target: String,
    public val userId: String,
    public val warnLevel: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sddp.outputs.GetRulesRule): GetRulesRule =
            GetRulesRule(
                category = javaType.category(),
                categoryName = javaType.categoryName(),
                content = javaType.content(),
                contentCategory = javaType.contentCategory(),
                createTime = javaType.createTime(),
                customType = javaType.customType(),
                description = javaType.description(),
                displayName = javaType.displayName(),
                gmtModified = javaType.gmtModified(),
                id = javaType.id(),
                loginName = javaType.loginName(),
                majorKey = javaType.majorKey(),
                name = javaType.name(),
                productCode = javaType.productCode(),
                productId = javaType.productId(),
                riskLevelId = javaType.riskLevelId(),
                riskLevelName = javaType.riskLevelName(),
                ruleId = javaType.ruleId(),
                statExpress = javaType.statExpress(),
                status = javaType.status(),
                target = javaType.target(),
                userId = javaType.userId(),
                warnLevel = javaType.warnLevel(),
            )
    }
}
