@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.securitycenter.kotlin

import com.pulumi.alicloud.securitycenter.SecuritycenterFunctions.getGroupsPlain
import com.pulumi.alicloud.securitycenter.kotlin.inputs.GetGroupsPlainArgs
import com.pulumi.alicloud.securitycenter.kotlin.inputs.GetGroupsPlainArgsBuilder
import com.pulumi.alicloud.securitycenter.kotlin.outputs.GetGroupsResult
import com.pulumi.alicloud.securitycenter.kotlin.outputs.GetGroupsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object SecuritycenterFunctions {
    /**
     * This data source provides the Security Center Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.133.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const nameRegex = alicloud.securitycenter.getGroups({
     *     nameRegex: "^my-Group",
     * });
     * export const securityCenterGroups = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * name_regex = alicloud.securitycenter.get_groups(name_regex="^my-Group")
     * pulumi.export("securityCenterGroups", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var nameRegex = AliCloud.SecurityCenter.GetGroups.Invoke(new()
     *     {
     *         NameRegex = "^my-Group",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["securityCenterGroups"] = nameRegex&#46;Apply(getGroupsResult => getGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/securitycenter"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		nameRegex, err := securitycenter.GetGroups(ctx, &securitycenter.GetGroupsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Group"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("securityCenterGroups", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.securitycenter.SecuritycenterFunctions;
     * import com.pulumi.alicloud.securitycenter.inputs.GetGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var nameRegex = SecuritycenterFunctions.getGroups(GetGroupsArgs.builder()
     *             .nameRegex("^my-Group")
     *             .build());
     *         ctx.export("securityCenterGroups", nameRegex.applyValue(getGroupsResult -> getGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:securitycenter:getGroups
     *       Arguments:
     *         nameRegex: ^my-Group
     * outputs:
     *   securityCenterGroups: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroups.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: GetGroupsPlainArgs): GetGroupsResult =
        toKotlin(getGroupsPlain(argument.toJava()).await())

    /**
     * @see [getGroups].
     * @param ids A list of Group IDs.
     * @param nameRegex A regex string to filter results by Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetGroupsResult {
        val argument = GetGroupsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return toKotlin(getGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;securitycenter&#46;kotlin&#46;inputs&#46;GetGroupsPlainArgs].
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: suspend GetGroupsPlainArgsBuilder.() -> Unit): GetGroupsResult {
        val builder = GetGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getGroupsPlain(builtArgument.toJava()).await())
    }
}
