@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.securitycenter.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceLinkedRole].
 */
@PulumiTagMarker
public class ServiceLinkedRoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceLinkedRoleArgs = ServiceLinkedRoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceLinkedRoleArgsBuilder.() -> Unit) {
        val builder = ServiceLinkedRoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceLinkedRole {
        val builtJavaResource =
            com.pulumi.alicloud.securitycenter.ServiceLinkedRole(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceLinkedRole(builtJavaResource)
    }
}

/**
 * Using this resource can create SecurityCenter service-linked role : `AliyunServiceRolePolicyForSas`.  This Role is a Resource Access Management (RAM) role, which to obtain permissions to access another Alibaba Cloud service.
 * For information about Security Center Service Role and how to use it, see [What is Security Center](https://www.alibabacloud.com/help/en/doc-detail/42302.htm).
 * > **NOTE:** Available in v1.142.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const serviceLinkedRole = new alicloud.securitycenter.ServiceLinkedRole("service_linked_role", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * service_linked_role = alicloud.securitycenter.ServiceLinkedRole("service_linked_role")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceLinkedRole = new AliCloud.SecurityCenter.ServiceLinkedRole("service_linked_role");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/securitycenter"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitycenter.NewServiceLinkedRole(ctx, "service_linked_role", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.securitycenter.ServiceLinkedRole;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceLinkedRole = new ServiceLinkedRole("serviceLinkedRole");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   serviceLinkedRole:
 *     type: alicloud:securitycenter:ServiceLinkedRole
 *     name: service_linked_role
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SecurityCenter service-linked roles(SLR) can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:securitycenter/serviceLinkedRole:ServiceLinkedRole example <product_name>
 * ```
 */
public class ServiceLinkedRole internal constructor(
    override val javaResource: com.pulumi.alicloud.securitycenter.ServiceLinkedRole,
) : KotlinCustomResource(javaResource, ServiceLinkedRoleMapper) {
    /**
     * The status of the service Associated role. Valid Values: `true`: Created. `false`: not created.
     */
    public val status: Output<Boolean>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ServiceLinkedRoleMapper : ResourceMapper<ServiceLinkedRole> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.securitycenter.ServiceLinkedRole::class == javaResource::class

    override fun map(javaResource: Resource): ServiceLinkedRole = ServiceLinkedRole(
        javaResource as
            com.pulumi.alicloud.securitycenter.ServiceLinkedRole,
    )
}

/**
 * @see [ServiceLinkedRole].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceLinkedRole].
 */
public suspend fun serviceLinkedRole(
    name: String,
    block: suspend ServiceLinkedRoleResourceBuilder.() -> Unit,
): ServiceLinkedRole {
    val builder = ServiceLinkedRoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceLinkedRole].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceLinkedRole(name: String): ServiceLinkedRole {
    val builder = ServiceLinkedRoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
