@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.securitycenter.kotlin

import com.pulumi.alicloud.securitycenter.ServiceLinkedRoleArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress

/**
 * Using this resource can create SecurityCenter service-linked role : `AliyunServiceRolePolicyForSas`.  This Role is a Resource Access Management (RAM) role, which to obtain permissions to access another Alibaba Cloud service.
 * For information about Security Center Service Role and how to use it, see [What is Security Center](https://www.alibabacloud.com/help/en/doc-detail/42302.htm).
 * > **NOTE:** Available in v1.142.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const serviceLinkedRole = new alicloud.securitycenter.ServiceLinkedRole("service_linked_role", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * service_linked_role = alicloud.securitycenter.ServiceLinkedRole("service_linked_role")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceLinkedRole = new AliCloud.SecurityCenter.ServiceLinkedRole("service_linked_role");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/securitycenter"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitycenter.NewServiceLinkedRole(ctx, "service_linked_role", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.securitycenter.ServiceLinkedRole;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceLinkedRole = new ServiceLinkedRole("serviceLinkedRole");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   serviceLinkedRole:
 *     type: alicloud:securitycenter:ServiceLinkedRole
 *     name: service_linked_role
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SecurityCenter service-linked roles(SLR) can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:securitycenter/serviceLinkedRole:ServiceLinkedRole example <product_name>
 * ```
 */
public class ServiceLinkedRoleArgs() :
    ConvertibleToJava<com.pulumi.alicloud.securitycenter.ServiceLinkedRoleArgs> {
    override fun toJava(): com.pulumi.alicloud.securitycenter.ServiceLinkedRoleArgs =
        com.pulumi.alicloud.securitycenter.ServiceLinkedRoleArgs.builder().build()
}

/**
 * Builder for [ServiceLinkedRoleArgs].
 */
@PulumiTagMarker
public class ServiceLinkedRoleArgsBuilder internal constructor() {
    internal fun build(): ServiceLinkedRoleArgs = ServiceLinkedRoleArgs()
}
