@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.securitycenter.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupFlag GroupFlag, '0' mean default group(created by system), '1' means customer defined group.
 * @property groupId The ID of Group.
 * @property groupName The name of Group.
 * @property id The ID of the Group(same as the group_id).
 */
public data class GetGroupsGroup(
    public val groupFlag: Int,
    public val groupId: String,
    public val groupName: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.securitycenter.outputs.GetGroupsGroup): GetGroupsGroup = GetGroupsGroup(
            groupFlag = javaType.groupFlag(),
            groupId = javaType.groupId(),
            groupName = javaType.groupName(),
            id = javaType.id(),
        )
    }
}
