@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin

import com.pulumi.alicloud.selectdb.kotlin.outputs.DbClusterDesiredParam
import com.pulumi.alicloud.selectdb.kotlin.outputs.DbClusterParamChangeLog
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.selectdb.kotlin.outputs.DbClusterDesiredParam.Companion.toKotlin as dbClusterDesiredParamToKotlin
import com.pulumi.alicloud.selectdb.kotlin.outputs.DbClusterParamChangeLog.Companion.toKotlin as dbClusterParamChangeLogToKotlin

/**
 * Builder for [DbCluster].
 */
@PulumiTagMarker
public class DbClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DbClusterArgs = DbClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DbClusterArgsBuilder.() -> Unit) {
        val builder = DbClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DbCluster {
        val builtJavaResource = com.pulumi.alicloud.selectdb.DbCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DbCluster(builtJavaResource)
    }
}

/**
 * Provides a SelectDB DBCluster resource.
 * For information about SelectDB DBCluster and how to use it, see [What is DBCluster](https://www.alibabacloud.com/help/zh/selectdb/latest/api-selectdb-2023-05-22-createdbcluster).
 * > **NOTE:** Available since v1.229.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.zones?.[0]?.id,
 * }));
 * const defaultDbInstance = new alicloud.selectdb.DbInstance("default", {
 *     dbInstanceClass: "selectdb.xlarge",
 *     dbInstanceDescription: name,
 *     cacheSize: 200,
 *     paymentType: "PayAsYouGo",
 *     vpcId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.vpcId),
 *     zoneId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.zoneId),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.id),
 * });
 * const defaultDbCluster = new alicloud.selectdb.DbCluster("default", {
 *     dbInstanceId: defaultDbInstance.id,
 *     dbClusterDescription: name,
 *     dbClusterClass: "selectdb.2xlarge",
 *     cacheSize: 400,
 *     paymentType: "PayAsYouGo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.zones[0].id)
 * default_db_instance = alicloud.selectdb.DbInstance("default",
 *     db_instance_class="selectdb.xlarge",
 *     db_instance_description=name,
 *     cache_size=200,
 *     payment_type="PayAsYouGo",
 *     vpc_id=default_get_switches.vswitches[0].vpc_id,
 *     zone_id=default_get_switches.vswitches[0].zone_id,
 *     vswitch_id=default_get_switches.vswitches[0].id)
 * default_db_cluster = alicloud.selectdb.DbCluster("default",
 *     db_instance_id=default_db_instance.id,
 *     db_cluster_description=name,
 *     db_cluster_class="selectdb.2xlarge",
 *     cache_size=400,
 *     payment_type="PayAsYouGo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultDbInstance = new AliCloud.SelectDB.DbInstance("default", new()
 *     {
 *         DbInstanceClass = "selectdb.xlarge",
 *         DbInstanceDescription = name,
 *         CacheSize = 200,
 *         PaymentType = "PayAsYouGo",
 *         VpcId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.VpcId),
 *         ZoneId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.ZoneId),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.Id),
 *     });
 *     var defaultDbCluster = new AliCloud.SelectDB.DbCluster("default", new()
 *     {
 *         DbInstanceId = defaultDbInstance.Id,
 *         DbClusterDescription = name,
 *         DbClusterClass = "selectdb.2xlarge",
 *         CacheSize = 400,
 *         PaymentType = "PayAsYouGo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/selectdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDbInstance, err := selectdb.NewDbInstance(ctx, "default", &selectdb.DbInstanceArgs{
 * 			DbInstanceClass:       pulumi.String("selectdb.xlarge"),
 * 			DbInstanceDescription: pulumi.String(name),
 * 			CacheSize:             pulumi.Int(200),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 			VpcId:                 pulumi.String(defaultGetSwitches.Vswitches[0].VpcId),
 * 			ZoneId:                pulumi.String(defaultGetSwitches.Vswitches[0].ZoneId),
 * 			VswitchId:             pulumi.String(defaultGetSwitches.Vswitches[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = selectdb.NewDbCluster(ctx, "default", &selectdb.DbClusterArgs{
 * 			DbInstanceId:         defaultDbInstance.ID(),
 * 			DbClusterDescription: pulumi.String(name),
 * 			DbClusterClass:       pulumi.String("selectdb.2xlarge"),
 * 			CacheSize:            pulumi.Int(400),
 * 			PaymentType:          pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.selectdb.DbInstance;
 * import com.pulumi.alicloud.selectdb.DbInstanceArgs;
 * import com.pulumi.alicloud.selectdb.DbCluster;
 * import com.pulumi.alicloud.selectdb.DbClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var name = config.get("name").orElse("terraform_example");
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultDbInstance = new DbInstance("defaultDbInstance", DbInstanceArgs.builder()
 *             .dbInstanceClass("selectdb.xlarge")
 *             .dbInstanceDescription(name)
 *             .cacheSize(200)
 *             .paymentType("PayAsYouGo")
 *             .vpcId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].vpcId()))
 *             .zoneId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].zoneId()))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].id()))
 *             .build());
 *         var defaultDbCluster = new DbCluster("defaultDbCluster", DbClusterArgs.builder()
 *             .dbInstanceId(defaultDbInstance.id())
 *             .dbClusterDescription(name)
 *             .dbClusterClass("selectdb.2xlarge")
 *             .cacheSize(400)
 *             .paymentType("PayAsYouGo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   defaultDbInstance:
 *     type: alicloud:selectdb:DbInstance
 *     name: default
 *     properties:
 *       dbInstanceClass: selectdb.xlarge
 *       dbInstanceDescription: ${name}
 *       cacheSize: 200
 *       paymentType: PayAsYouGo
 *       vpcId: ${defaultGetSwitches.vswitches[0].vpcId}
 *       zoneId: ${defaultGetSwitches.vswitches[0].zoneId}
 *       vswitchId: ${defaultGetSwitches.vswitches[0].id}
 *   defaultDbCluster:
 *     type: alicloud:selectdb:DbCluster
 *     name: default
 *     properties:
 *       dbInstanceId: ${defaultDbInstance.id}
 *       dbClusterDescription: ${name}
 *       dbClusterClass: selectdb.2xlarge
 *       cacheSize: 400
 *       paymentType: PayAsYouGo
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.zones[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SelectDB DBCluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:selectdb/dbCluster:DbCluster example <db_instance_id>:<db_cluster_id>
 * ```
 */
public class DbCluster internal constructor(
    override val javaResource: com.pulumi.alicloud.selectdb.DbCluster,
) : KotlinCustomResource(javaResource, DbClusterMapper) {
    /**
     * The desired cache size on creating cluster. The number should be divided by 100.
     */
    public val cacheSize: Output<Int>
        get() = javaResource.cacheSize().applyValue({ args0 -> args0 })

    /**
     * The cpu resource amount of DBCluster. Depends on `db_cluster_class`.
     */
    public val cpu: Output<Int>
        get() = javaResource.cpu().applyValue({ args0 -> args0 })

    /**
     * The time when DBCluster is created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
     */
    public val dbClusterClass: Output<String>
        get() = javaResource.dbClusterClass().applyValue({ args0 -> args0 })

    /**
     * The DBCluster description.
     */
    public val dbClusterDescription: Output<String>
        get() = javaResource.dbClusterDescription().applyValue({ args0 -> args0 })

    /**
     * The id of the cluster.
     */
    public val dbClusterId: Output<String>
        get() = javaResource.dbClusterId().applyValue({ args0 -> args0 })

    /**
     * The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
     */
    public val dbInstanceId: Output<String>
        get() = javaResource.dbInstanceId().applyValue({ args0 -> args0 })

    /**
     * The modified parameter in DBCluster. See `desired_params` below.
     */
    public val desiredParams: Output<List<DbClusterDesiredParam>>?
        get() = javaResource.desiredParams().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        dbClusterDesiredParamToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
     */
    public val desiredStatus: Output<String>?
        get() = javaResource.desiredStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The engine of DBCluster. Always `selectdb`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The version of DBCluster.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The memory resource amount of DBCluster. Depends on `db_cluster_class`.
     */
    public val memory: Output<Int>
        get() = javaResource.memory().applyValue({ args0 -> args0 })

    /**
     * The details about parameter changelogs in DBCluster returned.
     */
    public val paramChangeLogs: Output<List<DbClusterParamChangeLog>>
        get() = javaResource.paramChangeLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dbClusterParamChangeLogToKotlin(args0) })
            })
        })

    /**
     * The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The ID of region for the cluster.
     */
    public val regionId: Output<String>
        get() = javaResource.regionId().applyValue({ args0 -> args0 })

    /**
     * The current status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC for the cluster.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of zone for the cluster.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DbClusterMapper : ResourceMapper<DbCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.selectdb.DbCluster::class == javaResource::class

    override fun map(javaResource: Resource): DbCluster = DbCluster(
        javaResource as
            com.pulumi.alicloud.selectdb.DbCluster,
    )
}

/**
 * @see [DbCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DbCluster].
 */
public suspend fun dbCluster(name: String, block: suspend DbClusterResourceBuilder.() -> Unit): DbCluster {
    val builder = DbClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DbCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dbCluster(name: String): DbCluster {
    val builder = DbClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
