@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin

import com.pulumi.alicloud.selectdb.DbClusterArgs.builder
import com.pulumi.alicloud.selectdb.kotlin.inputs.DbClusterDesiredParamArgs
import com.pulumi.alicloud.selectdb.kotlin.inputs.DbClusterDesiredParamArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a SelectDB DBCluster resource.
 * For information about SelectDB DBCluster and how to use it, see [What is DBCluster](https://www.alibabacloud.com/help/zh/selectdb/latest/api-selectdb-2023-05-22-createdbcluster).
 * > **NOTE:** Available since v1.229.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.zones?.[0]?.id,
 * }));
 * const defaultDbInstance = new alicloud.selectdb.DbInstance("default", {
 *     dbInstanceClass: "selectdb.xlarge",
 *     dbInstanceDescription: name,
 *     cacheSize: 200,
 *     paymentType: "PayAsYouGo",
 *     vpcId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.vpcId),
 *     zoneId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.zoneId),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.id),
 * });
 * const defaultDbCluster = new alicloud.selectdb.DbCluster("default", {
 *     dbInstanceId: defaultDbInstance.id,
 *     dbClusterDescription: name,
 *     dbClusterClass: "selectdb.2xlarge",
 *     cacheSize: 400,
 *     paymentType: "PayAsYouGo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.zones[0].id)
 * default_db_instance = alicloud.selectdb.DbInstance("default",
 *     db_instance_class="selectdb.xlarge",
 *     db_instance_description=name,
 *     cache_size=200,
 *     payment_type="PayAsYouGo",
 *     vpc_id=default_get_switches.vswitches[0].vpc_id,
 *     zone_id=default_get_switches.vswitches[0].zone_id,
 *     vswitch_id=default_get_switches.vswitches[0].id)
 * default_db_cluster = alicloud.selectdb.DbCluster("default",
 *     db_instance_id=default_db_instance.id,
 *     db_cluster_description=name,
 *     db_cluster_class="selectdb.2xlarge",
 *     cache_size=400,
 *     payment_type="PayAsYouGo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultDbInstance = new AliCloud.SelectDB.DbInstance("default", new()
 *     {
 *         DbInstanceClass = "selectdb.xlarge",
 *         DbInstanceDescription = name,
 *         CacheSize = 200,
 *         PaymentType = "PayAsYouGo",
 *         VpcId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.VpcId),
 *         ZoneId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.ZoneId),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.Id),
 *     });
 *     var defaultDbCluster = new AliCloud.SelectDB.DbCluster("default", new()
 *     {
 *         DbInstanceId = defaultDbInstance.Id,
 *         DbClusterDescription = name,
 *         DbClusterClass = "selectdb.2xlarge",
 *         CacheSize = 400,
 *         PaymentType = "PayAsYouGo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/selectdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDbInstance, err := selectdb.NewDbInstance(ctx, "default", &selectdb.DbInstanceArgs{
 * 			DbInstanceClass:       pulumi.String("selectdb.xlarge"),
 * 			DbInstanceDescription: pulumi.String(name),
 * 			CacheSize:             pulumi.Int(200),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 			VpcId:                 pulumi.String(defaultGetSwitches.Vswitches[0].VpcId),
 * 			ZoneId:                pulumi.String(defaultGetSwitches.Vswitches[0].ZoneId),
 * 			VswitchId:             pulumi.String(defaultGetSwitches.Vswitches[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = selectdb.NewDbCluster(ctx, "default", &selectdb.DbClusterArgs{
 * 			DbInstanceId:         defaultDbInstance.ID(),
 * 			DbClusterDescription: pulumi.String(name),
 * 			DbClusterClass:       pulumi.String("selectdb.2xlarge"),
 * 			CacheSize:            pulumi.Int(400),
 * 			PaymentType:          pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.selectdb.DbInstance;
 * import com.pulumi.alicloud.selectdb.DbInstanceArgs;
 * import com.pulumi.alicloud.selectdb.DbCluster;
 * import com.pulumi.alicloud.selectdb.DbClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var name = config.get("name").orElse("terraform_example");
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultDbInstance = new DbInstance("defaultDbInstance", DbInstanceArgs.builder()
 *             .dbInstanceClass("selectdb.xlarge")
 *             .dbInstanceDescription(name)
 *             .cacheSize(200)
 *             .paymentType("PayAsYouGo")
 *             .vpcId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].vpcId()))
 *             .zoneId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].zoneId()))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].id()))
 *             .build());
 *         var defaultDbCluster = new DbCluster("defaultDbCluster", DbClusterArgs.builder()
 *             .dbInstanceId(defaultDbInstance.id())
 *             .dbClusterDescription(name)
 *             .dbClusterClass("selectdb.2xlarge")
 *             .cacheSize(400)
 *             .paymentType("PayAsYouGo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   defaultDbInstance:
 *     type: alicloud:selectdb:DbInstance
 *     name: default
 *     properties:
 *       dbInstanceClass: selectdb.xlarge
 *       dbInstanceDescription: ${name}
 *       cacheSize: 200
 *       paymentType: PayAsYouGo
 *       vpcId: ${defaultGetSwitches.vswitches[0].vpcId}
 *       zoneId: ${defaultGetSwitches.vswitches[0].zoneId}
 *       vswitchId: ${defaultGetSwitches.vswitches[0].id}
 *   defaultDbCluster:
 *     type: alicloud:selectdb:DbCluster
 *     name: default
 *     properties:
 *       dbInstanceId: ${defaultDbInstance.id}
 *       dbClusterDescription: ${name}
 *       dbClusterClass: selectdb.2xlarge
 *       cacheSize: 400
 *       paymentType: PayAsYouGo
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.zones[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SelectDB DBCluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:selectdb/dbCluster:DbCluster example <db_instance_id>:<db_cluster_id>
 * ```
 * @property cacheSize The desired cache size on creating cluster. The number should be divided by 100.
 * @property dbClusterClass The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
 * @property dbClusterDescription The DBCluster description.
 * @property dbInstanceId The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
 * @property desiredParams The modified parameter in DBCluster. See `desired_params` below.
 * @property desiredStatus The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
 * @property paymentType The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
 */
public data class DbClusterArgs(
    public val cacheSize: Output<Int>? = null,
    public val dbClusterClass: Output<String>? = null,
    public val dbClusterDescription: Output<String>? = null,
    public val dbInstanceId: Output<String>? = null,
    public val desiredParams: Output<List<DbClusterDesiredParamArgs>>? = null,
    public val desiredStatus: Output<String>? = null,
    public val paymentType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.selectdb.DbClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.selectdb.DbClusterArgs =
        com.pulumi.alicloud.selectdb.DbClusterArgs.builder()
            .cacheSize(cacheSize?.applyValue({ args0 -> args0 }))
            .dbClusterClass(dbClusterClass?.applyValue({ args0 -> args0 }))
            .dbClusterDescription(dbClusterDescription?.applyValue({ args0 -> args0 }))
            .dbInstanceId(dbInstanceId?.applyValue({ args0 -> args0 }))
            .desiredParams(
                desiredParams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .desiredStatus(desiredStatus?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbClusterArgs].
 */
@PulumiTagMarker
public class DbClusterArgsBuilder internal constructor() {
    private var cacheSize: Output<Int>? = null

    private var dbClusterClass: Output<String>? = null

    private var dbClusterDescription: Output<String>? = null

    private var dbInstanceId: Output<String>? = null

    private var desiredParams: Output<List<DbClusterDesiredParamArgs>>? = null

    private var desiredStatus: Output<String>? = null

    private var paymentType: Output<String>? = null

    /**
     * @param value The desired cache size on creating cluster. The number should be divided by 100.
     */
    @JvmName("uqrkxtnxbrmykvkn")
    public suspend fun cacheSize(`value`: Output<Int>) {
        this.cacheSize = value
    }

    /**
     * @param value The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
     */
    @JvmName("dxaacxyhcbntffbt")
    public suspend fun dbClusterClass(`value`: Output<String>) {
        this.dbClusterClass = value
    }

    /**
     * @param value The DBCluster description.
     */
    @JvmName("elcudxwlcbblpwis")
    public suspend fun dbClusterDescription(`value`: Output<String>) {
        this.dbClusterDescription = value
    }

    /**
     * @param value The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
     */
    @JvmName("eagclensujqtixdx")
    public suspend fun dbInstanceId(`value`: Output<String>) {
        this.dbInstanceId = value
    }

    /**
     * @param value The modified parameter in DBCluster. See `desired_params` below.
     */
    @JvmName("lsxbqvaokpupeltx")
    public suspend fun desiredParams(`value`: Output<List<DbClusterDesiredParamArgs>>) {
        this.desiredParams = value
    }

    @JvmName("utditafkmkaiwixh")
    public suspend fun desiredParams(vararg values: Output<DbClusterDesiredParamArgs>) {
        this.desiredParams = Output.all(values.asList())
    }

    /**
     * @param values The modified parameter in DBCluster. See `desired_params` below.
     */
    @JvmName("kqnjimkeogufcvfy")
    public suspend fun desiredParams(values: List<Output<DbClusterDesiredParamArgs>>) {
        this.desiredParams = Output.all(values)
    }

    /**
     * @param value The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
     */
    @JvmName("xmlrrhbdwtqujyfj")
    public suspend fun desiredStatus(`value`: Output<String>) {
        this.desiredStatus = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
     */
    @JvmName("udjirwnydrcjkqve")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The desired cache size on creating cluster. The number should be divided by 100.
     */
    @JvmName("yqgwintgaemshoku")
    public suspend fun cacheSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheSize = mapped
    }

    /**
     * @param value The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
     */
    @JvmName("lgduygsejnjgdywb")
    public suspend fun dbClusterClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterClass = mapped
    }

    /**
     * @param value The DBCluster description.
     */
    @JvmName("rgmphpuchmuytxqw")
    public suspend fun dbClusterDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterDescription = mapped
    }

    /**
     * @param value The InstanceId of DBInstance for DBCluster. Every DBCluster requires one DBInstance to rely on.
     */
    @JvmName("mddkptgqkthbscha")
    public suspend fun dbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceId = mapped
    }

    /**
     * @param value The modified parameter in DBCluster. See `desired_params` below.
     */
    @JvmName("ladavfjjqarkasxe")
    public suspend fun desiredParams(`value`: List<DbClusterDesiredParamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredParams = mapped
    }

    /**
     * @param argument The modified parameter in DBCluster. See `desired_params` below.
     */
    @JvmName("ffdmmjhtqhekkpva")
    public suspend fun desiredParams(argument: List<suspend DbClusterDesiredParamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DbClusterDesiredParamArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.desiredParams = mapped
    }

    /**
     * @param argument The modified parameter in DBCluster. See `desired_params` below.
     */
    @JvmName("qmwtwyiogrboglgu")
    public suspend fun desiredParams(vararg argument: suspend DbClusterDesiredParamArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DbClusterDesiredParamArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.desiredParams = mapped
    }

    /**
     * @param argument The modified parameter in DBCluster. See `desired_params` below.
     */
    @JvmName("awqcthfjnwldbtau")
    public suspend fun desiredParams(argument: suspend DbClusterDesiredParamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DbClusterDesiredParamArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.desiredParams = mapped
    }

    /**
     * @param values The modified parameter in DBCluster. See `desired_params` below.
     */
    @JvmName("fyqlokcyrmnmbtlk")
    public suspend fun desiredParams(vararg values: DbClusterDesiredParamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredParams = mapped
    }

    /**
     * @param value The desired status for the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
     */
    @JvmName("haujeedeefullcde")
    public suspend fun desiredStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredStatus = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
     */
    @JvmName("uvemtduuxsslbnvw")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    internal fun build(): DbClusterArgs = DbClusterArgs(
        cacheSize = cacheSize,
        dbClusterClass = dbClusterClass,
        dbClusterDescription = dbClusterDescription,
        dbInstanceId = dbInstanceId,
        desiredParams = desiredParams,
        desiredStatus = desiredStatus,
        paymentType = paymentType,
    )
}
