@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin

import com.pulumi.alicloud.selectdb.kotlin.outputs.DbInstanceDesiredSecurityIpList
import com.pulumi.alicloud.selectdb.kotlin.outputs.DbInstanceInstanceNetInfo
import com.pulumi.alicloud.selectdb.kotlin.outputs.DbInstanceSecurityIpList
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.selectdb.kotlin.outputs.DbInstanceDesiredSecurityIpList.Companion.toKotlin as dbInstanceDesiredSecurityIpListToKotlin
import com.pulumi.alicloud.selectdb.kotlin.outputs.DbInstanceInstanceNetInfo.Companion.toKotlin as dbInstanceInstanceNetInfoToKotlin
import com.pulumi.alicloud.selectdb.kotlin.outputs.DbInstanceSecurityIpList.Companion.toKotlin as dbInstanceSecurityIpListToKotlin

/**
 * Builder for [DbInstance].
 */
@PulumiTagMarker
public class DbInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DbInstanceArgs = DbInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DbInstanceArgsBuilder.() -> Unit) {
        val builder = DbInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DbInstance {
        val builtJavaResource = com.pulumi.alicloud.selectdb.DbInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DbInstance(builtJavaResource)
    }
}

/**
 * Provides a SelectDB DBInstance resource.
 * For information about SelectDB DBInstance and how to use it, see [What is DBInstance](https://www.alibabacloud.com/help/zh/selectdb/latest/api-selectdb-2023-05-22-createdbinstance).
 * > **NOTE:** Available since v1.229.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.zones?.[0]?.id,
 * }));
 * const defaultDbInstance = new alicloud.selectdb.DbInstance("default", {
 *     dbInstanceClass: "selectdb.xlarge",
 *     dbInstanceDescription: name,
 *     cacheSize: 200,
 *     paymentType: "PayAsYouGo",
 *     vpcId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.vpcId),
 *     zoneId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.zoneId),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.zones[0].id)
 * default_db_instance = alicloud.selectdb.DbInstance("default",
 *     db_instance_class="selectdb.xlarge",
 *     db_instance_description=name,
 *     cache_size=200,
 *     payment_type="PayAsYouGo",
 *     vpc_id=default_get_switches.vswitches[0].vpc_id,
 *     zone_id=default_get_switches.vswitches[0].zone_id,
 *     vswitch_id=default_get_switches.vswitches[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultDbInstance = new AliCloud.SelectDB.DbInstance("default", new()
 *     {
 *         DbInstanceClass = "selectdb.xlarge",
 *         DbInstanceDescription = name,
 *         CacheSize = 200,
 *         PaymentType = "PayAsYouGo",
 *         VpcId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.VpcId),
 *         ZoneId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.ZoneId),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/selectdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = selectdb.NewDbInstance(ctx, "default", &selectdb.DbInstanceArgs{
 * 			DbInstanceClass:       pulumi.String("selectdb.xlarge"),
 * 			DbInstanceDescription: pulumi.String(name),
 * 			CacheSize:             pulumi.Int(200),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 			VpcId:                 pulumi.String(defaultGetSwitches.Vswitches[0].VpcId),
 * 			ZoneId:                pulumi.String(defaultGetSwitches.Vswitches[0].ZoneId),
 * 			VswitchId:             pulumi.String(defaultGetSwitches.Vswitches[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.selectdb.DbInstance;
 * import com.pulumi.alicloud.selectdb.DbInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var name = config.get("name").orElse("terraform_example");
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultDbInstance = new DbInstance("defaultDbInstance", DbInstanceArgs.builder()
 *             .dbInstanceClass("selectdb.xlarge")
 *             .dbInstanceDescription(name)
 *             .cacheSize(200)
 *             .paymentType("PayAsYouGo")
 *             .vpcId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].vpcId()))
 *             .zoneId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].zoneId()))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   defaultDbInstance:
 *     type: alicloud:selectdb:DbInstance
 *     name: default
 *     properties:
 *       dbInstanceClass: selectdb.xlarge
 *       dbInstanceDescription: ${name}
 *       cacheSize: 200
 *       paymentType: PayAsYouGo
 *       vpcId: ${defaultGetSwitches.vswitches[0].vpcId}
 *       zoneId: ${defaultGetSwitches.vswitches[0].zoneId}
 *       vswitchId: ${defaultGetSwitches.vswitches[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.zones[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SelectDB DBInstance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:selectdb/dbInstance:DbInstance example <id>
 * ```
 */
public class DbInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.selectdb.DbInstance,
) : KotlinCustomResource(javaResource, DbInstanceMapper) {
    /**
     * The cache size in DBInstance on creating default cluster. The number should be divided by 100.
     */
    public val cacheSize: Output<Int>
        get() = javaResource.cacheSize().applyValue({ args0 -> args0 })

    /**
     * The sum of cache size for every `PayAsYouGo` clusters in DBInstance.
     */
    public val cacheSizePostpaid: Output<Int>
        get() = javaResource.cacheSizePostpaid().applyValue({ args0 -> args0 })

    /**
     * The sum of cache size for every `Subscription` clusters in DBInstance.
     */
    public val cacheSizePrepaid: Output<Int>
        get() = javaResource.cacheSizePrepaid().applyValue({ args0 -> args0 })

    /**
     * The sum of cluster counts for `PayAsYouGo` clusters in DBInstance.
     */
    public val clusterCountPostpaid: Output<Int>
        get() = javaResource.clusterCountPostpaid().applyValue({ args0 -> args0 })

    /**
     * The sum of cluster counts for `Subscription` clusters in DBInstance.
     */
    public val clusterCountPrepaid: Output<Int>
        get() = javaResource.clusterCountPrepaid().applyValue({ args0 -> args0 })

    /**
     * The sum of cpu resource amount for every `PayAsYouGo` clusters in DBInstance.
     */
    public val cpuPostpaid: Output<Int>
        get() = javaResource.cpuPostpaid().applyValue({ args0 -> args0 })

    /**
     * The sum of cpu resource amount for every `Subscription` clusters in DBInstance.
     */
    public val cpuPrepaid: Output<Int>
        get() = javaResource.cpuPrepaid().applyValue({ args0 -> args0 })

    /**
     * The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
     */
    public val dbInstanceClass: Output<String>
        get() = javaResource.dbInstanceClass().applyValue({ args0 -> args0 })

    /**
     * The DBInstance description.
     */
    public val dbInstanceDescription: Output<String>
        get() = javaResource.dbInstanceDescription().applyValue({ args0 -> args0 })

    /**
     * The modified IP address whitelists. See `desired_security_ip_lists` below.
     */
    public val desiredSecurityIpLists: Output<List<DbInstanceDesiredSecurityIpList>>?
        get() = javaResource.desiredSecurityIpLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        dbInstanceDesiredSecurityIpListToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * If DBInstance need to open public network, set it to `true`.
     */
    public val enablePublicNetwork: Output<Boolean>?
        get() = javaResource.enablePublicNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The engine of DBInstance. Always `selectdb`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The current DBInstance minor version.
     */
    public val engineMinorVersion: Output<String>
        get() = javaResource.engineMinorVersion().applyValue({ args0 -> args0 })

    /**
     * The time when DBInstance is created.
     */
    public val gmtCreated: Output<String>
        get() = javaResource.gmtCreated().applyValue({ args0 -> args0 })

    /**
     * The time when DBInstance will be expired. Available on `Subscription` DBInstance.
     */
    public val gmtExpired: Output<String>
        get() = javaResource.gmtExpired().applyValue({ args0 -> args0 })

    /**
     * The time when DBInstance is modified.
     */
    public val gmtModified: Output<String>
        get() = javaResource.gmtModified().applyValue({ args0 -> args0 })

    /**
     * The net infos for instances.
     */
    public val instanceNetInfos: Output<List<DbInstanceInstanceNetInfo>>
        get() = javaResource.instanceNetInfos().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dbInstanceInstanceNetInfoToKotlin(args0) })
            })
        })

    /**
     * The lock mode of the instance. Set the value to lock, which specifies that the instance is locked when it automatically expires or has an overdue payment.
     */
    public val lockMode: Output<String>
        get() = javaResource.lockMode().applyValue({ args0 -> args0 })

    /**
     * The reason why the instance is locked.
     */
    public val lockReason: Output<String>
        get() = javaResource.lockReason().applyValue({ args0 -> args0 })

    /**
     * The sum of memory resource amount offor every `PayAsYouGo` clusters in DBInstance.
     */
    public val memoryPostpaid: Output<Int>
        get() = javaResource.memoryPostpaid().applyValue({ args0 -> args0 })

    /**
     * The sum of memory resource amount offor every `Subscription` clusters in DBInstance.
     */
    public val memoryPrepaid: Output<Int>
        get() = javaResource.memoryPrepaid().applyValue({ args0 -> args0 })

    /**
     * The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
     */
    public val periodTime: Output<Int>?
        get() = javaResource.periodTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The region ID of the instance.
     */
    public val regionId: Output<String>
        get() = javaResource.regionId().applyValue({ args0 -> args0 })

    /**
     * The details about each IP address whitelist returned.
     */
    public val securityIpLists: Output<List<DbInstanceSecurityIpList>>
        get() = javaResource.securityIpLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dbInstanceSecurityIpListToKotlin(args0) })
            })
        })

    /**
     * The status of the resource. Valid values: `ACTIVE`,`STOPPED`,`STARTING`,`RESTART`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The sub domain of DBInstance.
     */
    public val subDomain: Output<String>
        get() = javaResource.subDomain().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The DBInstance minor version want to upgraded to.
     */
    public val upgradedEngineMinorVersion: Output<String>?
        get() = javaResource.upgradedEngineMinorVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the VPC for DBInstance.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of vswitch for DBInstance.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The ID of zone for DBInstance.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DbInstanceMapper : ResourceMapper<DbInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.selectdb.DbInstance::class == javaResource::class

    override fun map(javaResource: Resource): DbInstance = DbInstance(
        javaResource as
            com.pulumi.alicloud.selectdb.DbInstance,
    )
}

/**
 * @see [DbInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DbInstance].
 */
public suspend fun dbInstance(name: String, block: suspend DbInstanceResourceBuilder.() -> Unit): DbInstance {
    val builder = DbInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DbInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dbInstance(name: String): DbInstance {
    val builder = DbInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
