@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin

import com.pulumi.alicloud.selectdb.DbInstanceArgs.builder
import com.pulumi.alicloud.selectdb.kotlin.inputs.DbInstanceDesiredSecurityIpListArgs
import com.pulumi.alicloud.selectdb.kotlin.inputs.DbInstanceDesiredSecurityIpListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SelectDB DBInstance resource.
 * For information about SelectDB DBInstance and how to use it, see [What is DBInstance](https://www.alibabacloud.com/help/zh/selectdb/latest/api-selectdb-2023-05-22-createdbinstance).
 * > **NOTE:** Available since v1.229.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.zones?.[0]?.id,
 * }));
 * const defaultDbInstance = new alicloud.selectdb.DbInstance("default", {
 *     dbInstanceClass: "selectdb.xlarge",
 *     dbInstanceDescription: name,
 *     cacheSize: 200,
 *     paymentType: "PayAsYouGo",
 *     vpcId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.vpcId),
 *     zoneId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.zoneId),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.zones[0].id)
 * default_db_instance = alicloud.selectdb.DbInstance("default",
 *     db_instance_class="selectdb.xlarge",
 *     db_instance_description=name,
 *     cache_size=200,
 *     payment_type="PayAsYouGo",
 *     vpc_id=default_get_switches.vswitches[0].vpc_id,
 *     zone_id=default_get_switches.vswitches[0].zone_id,
 *     vswitch_id=default_get_switches.vswitches[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultDbInstance = new AliCloud.SelectDB.DbInstance("default", new()
 *     {
 *         DbInstanceClass = "selectdb.xlarge",
 *         DbInstanceDescription = name,
 *         CacheSize = 200,
 *         PaymentType = "PayAsYouGo",
 *         VpcId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.VpcId),
 *         ZoneId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.ZoneId),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/selectdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = selectdb.NewDbInstance(ctx, "default", &selectdb.DbInstanceArgs{
 * 			DbInstanceClass:       pulumi.String("selectdb.xlarge"),
 * 			DbInstanceDescription: pulumi.String(name),
 * 			CacheSize:             pulumi.Int(200),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 			VpcId:                 pulumi.String(defaultGetSwitches.Vswitches[0].VpcId),
 * 			ZoneId:                pulumi.String(defaultGetSwitches.Vswitches[0].ZoneId),
 * 			VswitchId:             pulumi.String(defaultGetSwitches.Vswitches[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.selectdb.DbInstance;
 * import com.pulumi.alicloud.selectdb.DbInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var name = config.get("name").orElse("terraform_example");
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultDbInstance = new DbInstance("defaultDbInstance", DbInstanceArgs.builder()
 *             .dbInstanceClass("selectdb.xlarge")
 *             .dbInstanceDescription(name)
 *             .cacheSize(200)
 *             .paymentType("PayAsYouGo")
 *             .vpcId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].vpcId()))
 *             .zoneId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].zoneId()))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   defaultDbInstance:
 *     type: alicloud:selectdb:DbInstance
 *     name: default
 *     properties:
 *       dbInstanceClass: selectdb.xlarge
 *       dbInstanceDescription: ${name}
 *       cacheSize: 200
 *       paymentType: PayAsYouGo
 *       vpcId: ${defaultGetSwitches.vswitches[0].vpcId}
 *       zoneId: ${defaultGetSwitches.vswitches[0].zoneId}
 *       vswitchId: ${defaultGetSwitches.vswitches[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.zones[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SelectDB DBInstance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:selectdb/dbInstance:DbInstance example <id>
 * ```
 * @property cacheSize The cache size in DBInstance on creating default cluster. The number should be divided by 100.
 * @property dbInstanceClass The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
 * @property dbInstanceDescription The DBInstance description.
 * @property desiredSecurityIpLists The modified IP address whitelists. See `desired_security_ip_lists` below.
 * @property enablePublicNetwork If DBInstance need to open public network, set it to `true`.
 * @property paymentType The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
 * @property period It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
 * @property periodTime The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * @property upgradedEngineMinorVersion The DBInstance minor version want to upgraded to.
 * @property vpcId The ID of the VPC for DBInstance.
 * @property vswitchId The ID of vswitch for DBInstance.
 * @property zoneId The ID of zone for DBInstance.
 */
public data class DbInstanceArgs(
    public val cacheSize: Output<Int>? = null,
    public val dbInstanceClass: Output<String>? = null,
    public val dbInstanceDescription: Output<String>? = null,
    public val desiredSecurityIpLists: Output<List<DbInstanceDesiredSecurityIpListArgs>>? = null,
    public val enablePublicNetwork: Output<Boolean>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<String>? = null,
    public val periodTime: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val upgradedEngineMinorVersion: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.selectdb.DbInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.selectdb.DbInstanceArgs =
        com.pulumi.alicloud.selectdb.DbInstanceArgs.builder()
            .cacheSize(cacheSize?.applyValue({ args0 -> args0 }))
            .dbInstanceClass(dbInstanceClass?.applyValue({ args0 -> args0 }))
            .dbInstanceDescription(dbInstanceDescription?.applyValue({ args0 -> args0 }))
            .desiredSecurityIpLists(
                desiredSecurityIpLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enablePublicNetwork(enablePublicNetwork?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodTime(periodTime?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .upgradedEngineMinorVersion(upgradedEngineMinorVersion?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbInstanceArgs].
 */
@PulumiTagMarker
public class DbInstanceArgsBuilder internal constructor() {
    private var cacheSize: Output<Int>? = null

    private var dbInstanceClass: Output<String>? = null

    private var dbInstanceDescription: Output<String>? = null

    private var desiredSecurityIpLists: Output<List<DbInstanceDesiredSecurityIpListArgs>>? = null

    private var enablePublicNetwork: Output<Boolean>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<String>? = null

    private var periodTime: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var upgradedEngineMinorVersion: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The cache size in DBInstance on creating default cluster. The number should be divided by 100.
     */
    @JvmName("jyewnkxyryoftcge")
    public suspend fun cacheSize(`value`: Output<Int>) {
        this.cacheSize = value
    }

    /**
     * @param value The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
     */
    @JvmName("clgwwonmcxbbkakp")
    public suspend fun dbInstanceClass(`value`: Output<String>) {
        this.dbInstanceClass = value
    }

    /**
     * @param value The DBInstance description.
     */
    @JvmName("qjvierjavtqsvipn")
    public suspend fun dbInstanceDescription(`value`: Output<String>) {
        this.dbInstanceDescription = value
    }

    /**
     * @param value The modified IP address whitelists. See `desired_security_ip_lists` below.
     */
    @JvmName("jgellwlkaidtlmep")
    public suspend fun desiredSecurityIpLists(`value`: Output<List<DbInstanceDesiredSecurityIpListArgs>>) {
        this.desiredSecurityIpLists = value
    }

    @JvmName("urfbhynvubsunmpx")
    public suspend fun desiredSecurityIpLists(vararg values: Output<DbInstanceDesiredSecurityIpListArgs>) {
        this.desiredSecurityIpLists = Output.all(values.asList())
    }

    /**
     * @param values The modified IP address whitelists. See `desired_security_ip_lists` below.
     */
    @JvmName("eubhkdcctqygxqst")
    public suspend fun desiredSecurityIpLists(values: List<Output<DbInstanceDesiredSecurityIpListArgs>>) {
        this.desiredSecurityIpLists = Output.all(values)
    }

    /**
     * @param value If DBInstance need to open public network, set it to `true`.
     */
    @JvmName("snsiurgcerqjyucs")
    public suspend fun enablePublicNetwork(`value`: Output<Boolean>) {
        this.enablePublicNetwork = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
     */
    @JvmName("bfpwgrkowciortxo")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
     */
    @JvmName("rovikkvbktetlujd")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
     */
    @JvmName("susbpyufotxyvrsc")
    public suspend fun periodTime(`value`: Output<Int>) {
        this.periodTime = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("vujmfxuonaqoilkx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The DBInstance minor version want to upgraded to.
     */
    @JvmName("nksbdxalgsbcspuc")
    public suspend fun upgradedEngineMinorVersion(`value`: Output<String>) {
        this.upgradedEngineMinorVersion = value
    }

    /**
     * @param value The ID of the VPC for DBInstance.
     */
    @JvmName("wdsehbyarfwslceu")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of vswitch for DBInstance.
     */
    @JvmName("dsjofptemmgbhyxx")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The ID of zone for DBInstance.
     */
    @JvmName("etskdhodlrslcefl")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The cache size in DBInstance on creating default cluster. The number should be divided by 100.
     */
    @JvmName("aqxmsartiixncfdg")
    public suspend fun cacheSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheSize = mapped
    }

    /**
     * @param value The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
     */
    @JvmName("cjbgxaasljjyhwlc")
    public suspend fun dbInstanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceClass = mapped
    }

    /**
     * @param value The DBInstance description.
     */
    @JvmName("hqfafmuxeeykukve")
    public suspend fun dbInstanceDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceDescription = mapped
    }

    /**
     * @param value The modified IP address whitelists. See `desired_security_ip_lists` below.
     */
    @JvmName("deobcqjjjkiqavqg")
    public suspend fun desiredSecurityIpLists(`value`: List<DbInstanceDesiredSecurityIpListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredSecurityIpLists = mapped
    }

    /**
     * @param argument The modified IP address whitelists. See `desired_security_ip_lists` below.
     */
    @JvmName("udasmsunpchbkvof")
    public suspend fun desiredSecurityIpLists(argument: List<suspend DbInstanceDesiredSecurityIpListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DbInstanceDesiredSecurityIpListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.desiredSecurityIpLists = mapped
    }

    /**
     * @param argument The modified IP address whitelists. See `desired_security_ip_lists` below.
     */
    @JvmName("pnnlxtiosqstixve")
    public suspend fun desiredSecurityIpLists(vararg argument: suspend DbInstanceDesiredSecurityIpListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DbInstanceDesiredSecurityIpListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.desiredSecurityIpLists = mapped
    }

    /**
     * @param argument The modified IP address whitelists. See `desired_security_ip_lists` below.
     */
    @JvmName("faaltlmbhwfgegik")
    public suspend fun desiredSecurityIpLists(argument: suspend DbInstanceDesiredSecurityIpListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DbInstanceDesiredSecurityIpListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.desiredSecurityIpLists = mapped
    }

    /**
     * @param values The modified IP address whitelists. See `desired_security_ip_lists` below.
     */
    @JvmName("jcmrdlxkxcoaiiuk")
    public suspend fun desiredSecurityIpLists(vararg values: DbInstanceDesiredSecurityIpListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredSecurityIpLists = mapped
    }

    /**
     * @param value If DBInstance need to open public network, set it to `true`.
     */
    @JvmName("popsangvfvikfuta")
    public suspend fun enablePublicNetwork(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePublicNetwork = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
     */
    @JvmName("efbieyditkskkhac")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
     */
    @JvmName("cclkxnsujjuhktxv")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
     */
    @JvmName("ypscfknjgxqjuffb")
    public suspend fun periodTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodTime = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("xvhykjqcefhcdbbw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("tvcfxaeputgenvne")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The DBInstance minor version want to upgraded to.
     */
    @JvmName("lwbgkgxcvywaxqyk")
    public suspend fun upgradedEngineMinorVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradedEngineMinorVersion = mapped
    }

    /**
     * @param value The ID of the VPC for DBInstance.
     */
    @JvmName("gltbljtloksedwwb")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of vswitch for DBInstance.
     */
    @JvmName("biouqnyadmmhjqdu")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The ID of zone for DBInstance.
     */
    @JvmName("jtardydjbhmbjnse")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DbInstanceArgs = DbInstanceArgs(
        cacheSize = cacheSize,
        dbInstanceClass = dbInstanceClass,
        dbInstanceDescription = dbInstanceDescription,
        desiredSecurityIpLists = desiredSecurityIpLists,
        enablePublicNetwork = enablePublicNetwork,
        paymentType = paymentType,
        period = period,
        periodTime = periodTime,
        tags = tags,
        upgradedEngineMinorVersion = upgradedEngineMinorVersion,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
