@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.inputs

import com.pulumi.alicloud.selectdb.inputs.DbClusterDesiredParamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Parameter name.
 * @property value The new value of Parameter.
 */
public data class DbClusterDesiredParamArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.selectdb.inputs.DbClusterDesiredParamArgs> {
    override fun toJava(): com.pulumi.alicloud.selectdb.inputs.DbClusterDesiredParamArgs =
        com.pulumi.alicloud.selectdb.inputs.DbClusterDesiredParamArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbClusterDesiredParamArgs].
 */
@PulumiTagMarker
public class DbClusterDesiredParamArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Parameter name.
     */
    @JvmName("vxqcmoaburnlcdic")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The new value of Parameter.
     */
    @JvmName("txdskxoeynottxlc")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Parameter name.
     */
    @JvmName("pntnqdmxeydtockd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The new value of Parameter.
     */
    @JvmName("ynuclbqaryilyvtc")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DbClusterDesiredParamArgs = DbClusterDesiredParamArgs(
        name = name,
        `value` = `value`,
    )
}
