@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.inputs

import com.pulumi.alicloud.selectdb.inputs.DbInstanceDesiredSecurityIpListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupName Security group name.
 * @property securityIpList The IP list of Security group. Each single IP value should be Separated by comma.
 */
public data class DbInstanceDesiredSecurityIpListArgs(
    public val groupName: Output<String>? = null,
    public val securityIpList: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.selectdb.inputs.DbInstanceDesiredSecurityIpListArgs> {
    override fun toJava(): com.pulumi.alicloud.selectdb.inputs.DbInstanceDesiredSecurityIpListArgs =
        com.pulumi.alicloud.selectdb.inputs.DbInstanceDesiredSecurityIpListArgs.builder()
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .securityIpList(securityIpList?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbInstanceDesiredSecurityIpListArgs].
 */
@PulumiTagMarker
public class DbInstanceDesiredSecurityIpListArgsBuilder internal constructor() {
    private var groupName: Output<String>? = null

    private var securityIpList: Output<String>? = null

    /**
     * @param value Security group name.
     */
    @JvmName("sjkupbnldowrfphj")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The IP list of Security group. Each single IP value should be Separated by comma.
     */
    @JvmName("dslulkfieilfmorr")
    public suspend fun securityIpList(`value`: Output<String>) {
        this.securityIpList = value
    }

    /**
     * @param value Security group name.
     */
    @JvmName("yfvsywocijtcyrjt")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The IP list of Security group. Each single IP value should be Separated by comma.
     */
    @JvmName("anskqflrerwtrvwp")
    public suspend fun securityIpList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpList = mapped
    }

    internal fun build(): DbInstanceDesiredSecurityIpListArgs = DbInstanceDesiredSecurityIpListArgs(
        groupName = groupName,
        securityIpList = securityIpList,
    )
}
