@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.inputs

import com.pulumi.alicloud.selectdb.inputs.GetDbClustersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDbClusters.
 * @property ids A list of DBCluster IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetDbClustersPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.selectdb.inputs.GetDbClustersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.selectdb.inputs.GetDbClustersPlainArgs =
        com.pulumi.alicloud.selectdb.inputs.GetDbClustersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDbClustersPlainArgs].
 */
@PulumiTagMarker
public class GetDbClustersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value A list of DBCluster IDs.
     */
    @JvmName("wuxfbsmewtdvjnbe")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of DBCluster IDs.
     */
    @JvmName("duldvhwuwxsmkmpk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("btyxkrqkwnikwlkv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetDbClustersPlainArgs = GetDbClustersPlainArgs(
        ids = ids,
        outputFile = outputFile,
    )
}
