@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property configId The id of parameter change.
 * @property gmtCreated When the parameter change is created.
 * @property gmtModified When the parameter change is modified.
 * @property isApplied Whether the parameter changing is applied.
 * @property name Changed parameter name.
 * @property newValue The new value of parameter.
 * @property oldValue The old value of parameter.
 */
public data class DbClusterParamChangeLog(
    public val configId: Int? = null,
    public val gmtCreated: String? = null,
    public val gmtModified: String? = null,
    public val isApplied: Boolean? = null,
    public val name: String? = null,
    public val newValue: String? = null,
    public val oldValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.selectdb.outputs.DbClusterParamChangeLog): DbClusterParamChangeLog = DbClusterParamChangeLog(
            configId = javaType.configId().map({ args0 -> args0 }).orElse(null),
            gmtCreated = javaType.gmtCreated().map({ args0 -> args0 }).orElse(null),
            gmtModified = javaType.gmtModified().map({ args0 -> args0 }).orElse(null),
            isApplied = javaType.isApplied().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            newValue = javaType.newValue().map({ args0 -> args0 }).orElse(null),
            oldValue = javaType.oldValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
