@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionString The connection string of the instance.
 * @property dbIp The IP address of the instance.
 * @property netType The network type of the instance.
 * @property portLists A list for port provides SelectDB service.
 * @property vpcInstanceId The VPC ID.
 * @property vswitchId The ID of vswitch for DBInstance.
 */
public data class DbInstanceInstanceNetInfo(
    public val connectionString: String? = null,
    public val dbIp: String? = null,
    public val netType: String? = null,
    public val portLists: List<DbInstanceInstanceNetInfoPortList>? = null,
    public val vpcInstanceId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.selectdb.outputs.DbInstanceInstanceNetInfo): DbInstanceInstanceNetInfo = DbInstanceInstanceNetInfo(
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            dbIp = javaType.dbIp().map({ args0 -> args0 }).orElse(null),
            netType = javaType.netType().map({ args0 -> args0 }).orElse(null),
            portLists = javaType.portLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.selectdb.kotlin.outputs.DbInstanceInstanceNetInfoPortList.Companion.toKotlin(args0)
                })
            }),
            vpcInstanceId = javaType.vpcInstanceId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
