@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupName Security group name.
 * @property groupTag The tag of Security group.
 * @property listNetType The network type of Security group.
 * @property securityIpList The IP list of Security group. Each single IP value should be Separated by comma.
 * @property securityIpType The IP address type. Valid values: `ipv4`, `ipv6` (not supported).
 */
public data class DbInstanceSecurityIpList(
    public val groupName: String? = null,
    public val groupTag: String? = null,
    public val listNetType: String? = null,
    public val securityIpList: String? = null,
    public val securityIpType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.selectdb.outputs.DbInstanceSecurityIpList): DbInstanceSecurityIpList = DbInstanceSecurityIpList(
            groupName = javaType.groupName().map({ args0 -> args0 }).orElse(null),
            groupTag = javaType.groupTag().map({ args0 -> args0 }).orElse(null),
            listNetType = javaType.listNetType().map({ args0 -> args0 }).orElse(null),
            securityIpList = javaType.securityIpList().map({ args0 -> args0 }).orElse(null),
            securityIpType = javaType.securityIpType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
